/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class MultiTableHFileOutputFormat
extends HFileOutputFormat2 {
    private static final Logger LOG = LoggerFactory.getLogger(MultiTableHFileOutputFormat.class);

    public static byte[] createCompositeKey(byte[] tableName, byte[] suffix) {
        return MultiTableHFileOutputFormat.combineTableNameSuffix(tableName, suffix);
    }

    public static byte[] createCompositeKey(byte[] tableName, ImmutableBytesWritable suffix) {
        return MultiTableHFileOutputFormat.combineTableNameSuffix(tableName, suffix.get());
    }

    public static byte[] createCompositeKey(String tableName, ImmutableBytesWritable suffix) {
        return MultiTableHFileOutputFormat.combineTableNameSuffix(tableName.getBytes(Charset.forName("UTF-8")), suffix.get());
    }

    public static void configureIncrementalLoad(Job job, List<HFileOutputFormat2.TableInfo> multiTableDescriptors) throws IOException {
        MultiTableHFileOutputFormat.configureIncrementalLoad(job, multiTableDescriptors, MultiTableHFileOutputFormat.class);
    }

    private static final int validateCompositeKey(byte[] keyBytes) {
        int separatorIdx = Bytes.indexOf((byte[])keyBytes, (byte[])tableSeparator);
        if (separatorIdx == -1) {
            throw new IllegalArgumentException("Invalid format for composite key [" + Bytes.toStringBinary((byte[])keyBytes) + "]. Cannot extract tablename and suffix from key");
        }
        return separatorIdx;
    }

    protected static byte[] getTableName(byte[] keyBytes) {
        int separatorIdx = MultiTableHFileOutputFormat.validateCompositeKey(keyBytes);
        return Bytes.copy((byte[])keyBytes, (int)0, (int)separatorIdx);
    }

    protected static byte[] getSuffix(byte[] keyBytes) {
        int separatorIdx = MultiTableHFileOutputFormat.validateCompositeKey(keyBytes);
        return Bytes.copy((byte[])keyBytes, (int)(separatorIdx + 1), (int)(keyBytes.length - separatorIdx - 1));
    }
}

