/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import org.apache.pig.SortInfo;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class LOStore
extends LogicalRelationalOperator {
    private final FileSpec output;
    private FileSpec mInputSpec;
    private final String signature;
    private boolean isTmpStore;
    private SortInfo sortInfo;
    private final StoreFuncInterface storeFunc;
    private boolean disambiguationEnabled = true;

    public LOStore(LogicalPlan plan, FileSpec outputFileSpec, StoreFuncInterface storeFunc, String signature) {
        super("LOStore", plan);
        this.output = outputFileSpec;
        this.storeFunc = storeFunc;
        this.signature = signature;
    }

    public LOStore(LogicalPlan plan, FileSpec outputFileSpec, StoreFuncInterface storeFunc, String signature, boolean disambiguationEnabled) {
        this(plan, outputFileSpec, storeFunc, signature);
        this.disambiguationEnabled = disambiguationEnabled;
    }

    public FileSpec getOutputSpec() {
        return this.output;
    }

    public StoreFuncInterface getStoreFunc() {
        return this.storeFunc;
    }

    @Override
    public LogicalSchema getSchema() throws FrontendException {
        this.schema = ((LogicalRelationalOperator)this.plan.getPredecessors(this).get(0)).getSchema();
        if (!this.disambiguationEnabled) {
            LOStore.removeDisambiguation(this.schema);
        }
        return this.schema;
    }

    private static LogicalSchema removeDisambiguation(LogicalSchema schema) {
        if (schema != null && schema.getFields() != null) {
            for (LogicalSchema.LogicalFieldSchema field : schema.getFields()) {
                if (field.schema != null) {
                    LOStore.removeDisambiguation(field.schema);
                }
                if (field.alias == null || !field.alias.contains(":")) continue;
                field.alias = field.alias.substring(field.alias.lastIndexOf(":") + 1);
            }
        }
        return schema;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof LOStore) {
            LOStore os = (LOStore)other;
            if (!this.checkEquality(os)) {
                return false;
            }
            if (this.output == null && os.output == null) {
                return true;
            }
            if (this.output == null || os.output == null) {
                return false;
            }
            return this.output.equals(os.output);
        }
        return false;
    }

    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    public void setSortInfo(SortInfo sortInfo) {
        this.sortInfo = sortInfo;
    }

    public boolean isTmpStore() {
        return this.isTmpStore;
    }

    public void setTmpStore(boolean isTmpStore) {
        this.isTmpStore = isTmpStore;
    }

    public void setInputSpec(FileSpec in) {
        this.mInputSpec = in;
    }

    public FileSpec getInputSpec() {
        return this.mInputSpec;
    }

    public String getSignature() {
        return this.signature;
    }

    public FileSpec getFileSpec() {
        return this.output;
    }
}

