/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoinTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.ObjectCache;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.util.Pair;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class POMergeCogroupTez
extends POMergeCogroup
implements TezInput {
    private static final Log LOG = LogFactory.getLog(POMergeJoinTez.class);
    private static final long serialVersionUID = 1L;
    private String inputKey;
    private transient String cacheKey;
    private transient KeyValueReader reader;
    private transient List<Pair<Integer, Tuple>> index;

    public POMergeCogroupTez(OperatorKey k, List<PhysicalOperator> inpPOs, POLocalRearrange[] lrs, int parallel) {
        super(k, inpPOs, lrs, parallel);
    }

    public POMergeCogroupTez(POMergeCogroup copy) {
        super(copy);
    }

    public void setInputKey(String inputKey) {
        this.inputKey = inputKey;
    }

    @Override
    public String[] getTezInputs() {
        return new String[]{this.inputKey};
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        this.inputKey = newInputKey;
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
        this.cacheKey = "mergecogrp-" + this.inputKey;
        Object cacheValue = ObjectCache.getInstance().retrieve(this.cacheKey);
        if (cacheValue != null) {
            inputsToSkip.add(this.inputKey);
        }
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        Object cacheValue = ObjectCache.getInstance().retrieve(this.cacheKey);
        if (cacheValue != null) {
            this.index = (LinkedList)cacheValue;
            return;
        }
        LogicalInput input = inputs.get(this.inputKey);
        if (input == null) {
            throw new ExecException("Input from vertex " + this.inputKey + " is missing");
        }
        try {
            input = inputs.get(this.inputKey);
            this.reader = (KeyValueReader)input.getReader();
            LOG.info((Object)("Attached input from vertex " + this.inputKey + " : input=" + input + ", reader=" + this.reader));
            this.index = new LinkedList<Pair<Integer, Tuple>>();
            while (this.reader.next()) {
                Tuple origTuple = (Tuple)this.reader.getCurrentValue();
                Tuple copyTuple = mTupleFactory.newTuple(origTuple.getAll());
                this.addTupleToIndex(copyTuple, this.index);
            }
            ObjectCache.getInstance().cache(this.cacheKey, this.index);
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    @Override
    public String name() {
        return super.name().replace("MergeCogroup", "MergeCogroupTez") + "\t<-\t " + this.inputKey;
    }

    @Override
    protected List<Pair<Integer, Tuple>> readIndex() {
        return this.index;
    }

    @Override
    public POMergeCogroupTez clone() throws CloneNotSupportedException {
        return (POMergeCogroupTez)super.clone();
    }
}

