/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans;

import java.io.PrintStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.NativeMapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.XMLPhysicalPlanPrinter;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLMRPrinter
extends MROpPlanVisitor {
    private PrintStream mStream = null;
    private Document doc = null;
    private Element root = null;

    public XMLMRPrinter(PrintStream ps, MROperPlan plan) throws ParserConfigurationException {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DepthFirstWalker<MapReduceOper, MROperPlan>(plan));
        this.mStream = ps;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.doc = builder.newDocument();
        this.root = this.doc.createElement("mapReducePlan");
        this.doc.appendChild(this.root);
    }

    public void closePlan() throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(this.doc);
        transformer.transform(source, result);
        this.mStream.println(sw.toString());
    }

    @Override
    public void visitMROp(MapReduceOper mr) throws VisitorException {
        XMLPhysicalPlanPrinter printer;
        Element mrNode = this.doc.createElement("mapReduceNode");
        mrNode.setAttribute("scope", "" + mr.getOperatorKey().id);
        if (mr instanceof NativeMapReduceOper) {
            Element nativeMROper = this.doc.createElement("nativeMapReduce");
            nativeMROper.setTextContent(((NativeMapReduceOper)mr).getCommandString());
            mrNode.appendChild(nativeMROper);
            this.root.appendChild(mrNode);
            return;
        }
        if (mr.mapPlan != null && mr.mapPlan.size() > 0) {
            Element mrPlanNode = this.doc.createElement("map");
            printer = new XMLPhysicalPlanPrinter(mr.mapPlan, this.doc, mrPlanNode);
            printer.visit();
            mrNode.appendChild(mrPlanNode);
        }
        if (mr.combinePlan != null && mr.combinePlan.size() > 0) {
            Element cPlanNode = this.doc.createElement("combine");
            printer = new XMLPhysicalPlanPrinter(mr.combinePlan, this.doc, cPlanNode);
            printer.visit();
            mrNode.appendChild(cPlanNode);
        }
        if (mr.reducePlan != null && mr.reducePlan.size() > 0) {
            Element rPlanNode = this.doc.createElement("reduce");
            printer = new XMLPhysicalPlanPrinter(mr.reducePlan, this.doc, rPlanNode);
            printer.visit();
            mrNode.appendChild(rPlanNode);
        }
        this.root.appendChild(mrNode);
    }
}

