/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.SplitLocationInfo;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.pig.data.WritableByteArray;
import org.apache.pig.impl.plan.OperatorKey;

public class PigSplit
extends InputSplit
implements Writable,
Configurable {
    private static String FILESPLIT_CLASSNAME = FileSplit.class.getName();
    private ArrayList<OperatorKey> targetOps;
    private int inputIndex;
    private InputSplit[] wrappedSplits;
    private int splitIndex;
    private int currentIdx;
    private boolean isMultiInputs = false;
    private boolean disableCounter = false;
    private Configuration conf;
    private int totalSplits;
    private long length = -1L;
    String[] locations = null;
    SplitLocationInfo[] splitLocationInfos = null;

    public PigSplit() {
    }

    public PigSplit(InputSplit[] wrappedSplits, int inputIndex, List<OperatorKey> targetOps, int splitIndex) {
        this.wrappedSplits = wrappedSplits;
        this.inputIndex = inputIndex;
        this.targetOps = new ArrayList<OperatorKey>(targetOps);
        this.splitIndex = splitIndex;
        this.currentIdx = 0;
    }

    public List<OperatorKey> getTargetOps() {
        return new ArrayList<OperatorKey>(this.targetOps);
    }

    public InputSplit getWrappedSplit() {
        return this.wrappedSplits[this.currentIdx];
    }

    public InputSplit getWrappedSplit(int idx) {
        return this.wrappedSplits[idx];
    }

    public String[] getLocations() throws IOException, InterruptedException {
        if (this.locations == null) {
            HashMap<String, Long> locMap = new HashMap<String, Long>();
            for (InputSplit split : this.wrappedSplits) {
                String[] locs;
                for (String loc : locs = split.getLocations()) {
                    Long lenInMap = (Long)locMap.get(loc);
                    if (lenInMap == null) {
                        locMap.put(loc, split.getLength());
                        continue;
                    }
                    locMap.put(loc, lenInMap + split.getLength());
                }
            }
            Set entrySet = locMap.entrySet();
            Map.Entry[] hostSize = entrySet.toArray(new Map.Entry[entrySet.size()]);
            Arrays.sort(hostSize, new Comparator<Map.Entry<String, Long>>(){

                @Override
                public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                    long diff = o1.getValue() - o2.getValue();
                    if (diff < 0L) {
                        return 1;
                    }
                    if (diff > 0L) {
                        return -1;
                    }
                    return 0;
                }
            });
            int nHost = Math.min(hostSize.length, 5);
            this.locations = new String[nHost];
            for (int i = 0; i < nHost; ++i) {
                this.locations[i] = (String)hostSize[i].getKey();
            }
        }
        return this.locations;
    }

    public SplitLocationInfo[] getLocationInfo() throws IOException {
        if (this.splitLocationInfos == null) {
            HashMap<SplitLocationInfo, Long> locMap = new HashMap<SplitLocationInfo, Long>();
            for (InputSplit split : this.wrappedSplits) {
                SplitLocationInfo[] locs = split.getLocationInfo();
                if (locs == null) continue;
                for (SplitLocationInfo loc : locs) {
                    try {
                        Long lenInMap = (Long)locMap.get(loc);
                        if (lenInMap == null) {
                            locMap.put(loc, split.getLength());
                            continue;
                        }
                        locMap.put(loc, lenInMap + split.getLength());
                    }
                    catch (InterruptedException e) {
                        throw new IOException("InputSplit.getLength throws exception: ", e);
                    }
                }
            }
            Set entrySet = locMap.entrySet();
            Map.Entry[] hostSize = entrySet.toArray(new Map.Entry[entrySet.size()]);
            Arrays.sort(hostSize, new Comparator<Map.Entry<SplitLocationInfo, Long>>(){

                @Override
                public int compare(Map.Entry<SplitLocationInfo, Long> o1, Map.Entry<SplitLocationInfo, Long> o2) {
                    long diff = o1.getValue() - o2.getValue();
                    if (diff < 0L) {
                        return 1;
                    }
                    if (diff > 0L) {
                        return -1;
                    }
                    return 0;
                }
            });
            int nHost = Math.min(hostSize.length, 5);
            this.splitLocationInfos = new SplitLocationInfo[nHost];
            for (int i = 0; i < nHost; ++i) {
                this.splitLocationInfos[i] = (SplitLocationInfo)hostSize[i].getKey();
            }
        }
        return this.splitLocationInfos;
    }

    public long getLength() throws IOException, InterruptedException {
        if (this.length == -1L) {
            this.length = 0L;
            for (int i = 0; i < this.wrappedSplits.length; ++i) {
                this.length += this.wrappedSplits[i].getLength();
            }
        }
        return this.length;
    }

    public long getLength(int idx) throws IOException, InterruptedException {
        return this.wrappedSplits[idx].getLength();
    }

    public void readFields(DataInput is) throws IOException {
        this.disableCounter = is.readBoolean();
        this.isMultiInputs = is.readBoolean();
        this.totalSplits = is.readInt();
        this.splitIndex = is.readInt();
        this.inputIndex = is.readInt();
        this.targetOps = (ArrayList)this.readObject(is);
        int splitLen = is.readInt();
        int distinctSplitClassCount = is.readInt();
        boolean nonFileSplit = false;
        String[] distinctSplitClassName = new String[distinctSplitClassCount];
        for (int i = 0; i < distinctSplitClassCount; ++i) {
            distinctSplitClassName[i] = is.readUTF();
            if (distinctSplitClassName[i].equals(FILESPLIT_CLASSNAME)) continue;
            nonFileSplit = true;
        }
        try {
            SerializationFactory sf = new SerializationFactory(this.conf);
            this.wrappedSplits = new InputSplit[splitLen];
            if (splitLen <= 0) {
                return;
            }
            boolean compress = nonFileSplit && this.conf.getBoolean("pig.compress.input.splits", false);
            DataInput dis = null;
            if (compress) {
                int numBytes = is.readInt();
                byte[] buf = new byte[numBytes];
                is.readFully(buf, 0, numBytes);
                dis = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(buf)));
            }
            DataInput dataIn = compress ? dis : is;
            for (int i = 0; i < splitLen; ++i) {
                int index = dataIn.readInt();
                String splitClassName = distinctSplitClassName[index];
                Class splitClass = this.conf.getClassByName(splitClassName);
                Deserializer d = sf.getDeserializer(splitClass);
                d.open((InputStream)((Object)dataIn));
                this.wrappedSplits[i] = (InputSplit)ReflectionUtils.newInstance((Class)splitClass, (Configuration)this.conf);
                d.deserialize((Object)this.wrappedSplits[i]);
            }
            if (compress && splitLen > 0) {
                ((FilterInputStream)((Object)dis)).close();
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public void write(DataOutput os) throws IOException {
        os.writeBoolean(this.disableCounter);
        os.writeBoolean(this.isMultiInputs);
        os.writeInt(this.totalSplits);
        os.writeInt(this.splitIndex);
        os.writeInt(this.inputIndex);
        this.writeObject(this.targetOps, os);
        os.writeInt(this.wrappedSplits.length);
        HashSet<String> splitClassNameSet = new HashSet<String>();
        for (int i = 0; i < this.wrappedSplits.length; ++i) {
            splitClassNameSet.add(this.wrappedSplits[i].getClass().getName());
        }
        ArrayList<String> distinctSplitClassList = new ArrayList<String>();
        distinctSplitClassList.addAll(splitClassNameSet);
        boolean nonFileSplit = distinctSplitClassList.size() > 1 || !distinctSplitClassList.contains(FILESPLIT_CLASSNAME);
        os.writeInt(distinctSplitClassList.size());
        for (int i = 0; i < distinctSplitClassList.size(); ++i) {
            os.writeUTF((String)distinctSplitClassList.get(i));
        }
        SerializationFactory sf = new SerializationFactory(this.conf);
        if (this.wrappedSplits.length <= 0) {
            return;
        }
        boolean compress = nonFileSplit && this.conf.getBoolean("pig.compress.input.splits", false);
        WritableByteArray byteStream = null;
        Deflater deflater = null;
        DataOutput dos = null;
        if (compress) {
            byteStream = new WritableByteArray(16384);
            deflater = new Deflater(9);
            dos = new DataOutputStream(new DeflaterOutputStream((OutputStream)byteStream, deflater));
        }
        DataOutput dataOut = compress ? dos : os;
        for (int i = 0; i < this.wrappedSplits.length; ++i) {
            int index = distinctSplitClassList.indexOf(this.wrappedSplits[i].getClass().getName());
            dataOut.writeInt(index);
            Serializer s = sf.getSerializer(this.wrappedSplits[i].getClass());
            if (s == null) {
                throw new IllegalArgumentException("Could not find Serializer for class " + this.wrappedSplits[i].getClass() + ". InputSplits must implement Writable.");
            }
            s.open((OutputStream)((Object)dataOut));
            s.serialize((Object)this.wrappedSplits[i]);
        }
        if (compress) {
            ((FilterOutputStream)((Object)dos)).close();
            os.writeInt(byteStream.getLength());
            os.write(byteStream.getData(), 0, byteStream.getLength());
            deflater.end();
        }
    }

    private void writeObject(Serializable obj, DataOutput os) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.flush();
        byte[] bytes = baos.toByteArray();
        os.writeInt(bytes.length);
        os.write(bytes);
    }

    private Object readObject(DataInput is) throws IOException {
        byte[] bytes = new byte[is.readInt()];
        is.readFully(bytes);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            return ois.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            IOException newE = new IOException(cnfe.getMessage());
            newE.initCause(cnfe);
            throw newE;
        }
    }

    public int getSplitIndex() {
        return this.splitIndex;
    }

    public void setMultiInputs(boolean b) {
        this.isMultiInputs = b;
    }

    public boolean isMultiInputs() {
        return this.isMultiInputs;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    int getInputIndex() {
        return this.inputIndex;
    }

    public int getNumPaths() {
        return this.wrappedSplits.length;
    }

    int getTotalSplits() {
        return this.totalSplits;
    }

    void setTotalSplits(int totalSplits) {
        this.totalSplits = totalSplits;
    }

    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append("Number of splits :" + this.wrappedSplits.length + "\n");
        try {
            st.append("Total Length = " + this.getLength() + "\n");
            for (int i = 0; i < this.wrappedSplits.length; ++i) {
                st.append("Input split[" + i + "]:\n   Length = " + this.wrappedSplits[i].getLength() + "\n   ClassName: " + this.wrappedSplits[i].getClass().getName() + "\n   Locations:\n");
                if (this.wrappedSplits[i] == null || this.wrappedSplits[i].getLocations() == null) continue;
                for (String location : this.wrappedSplits[i].getLocations()) {
                    st.append("    " + location + "\n");
                }
                st.append("\n-----------------------\n");
            }
        }
        catch (IOException e) {
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        return st.toString();
    }

    public void setDisableCounter(boolean disableCounter) {
        this.disableCounter = disableCounter;
    }

    public boolean disableCounter() {
        return this.disableCounter;
    }

    public void setCurrentIdx(int idx) {
        this.currentIdx = idx;
    }
}

