/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.SortedRanges;
import org.junit.Assert;
import org.junit.Test;

public class TestSortedRanges {
    private static final Log LOG = LogFactory.getLog(TestSortedRanges.class);

    @Test
    public void testAdd() {
        SortedRanges sr = new SortedRanges();
        sr.add(new SortedRanges.Range(2L, 9L));
        Assert.assertEquals((long)9L, (long)sr.getIndicesCount());
        sr.add(new SortedRanges.Range(3L, 5L));
        Assert.assertEquals((long)9L, (long)sr.getIndicesCount());
        sr.add(new SortedRanges.Range(7L, 1L));
        Assert.assertEquals((long)9L, (long)sr.getIndicesCount());
        sr.add(new SortedRanges.Range(1L, 12L));
        Assert.assertEquals((long)12L, (long)sr.getIndicesCount());
        sr.add(new SortedRanges.Range(7L, 9L));
        Assert.assertEquals((long)15L, (long)sr.getIndicesCount());
        sr.add(new SortedRanges.Range(31L, 10L));
        sr.add(new SortedRanges.Range(51L, 10L));
        sr.add(new SortedRanges.Range(66L, 10L));
        Assert.assertEquals((long)45L, (long)sr.getIndicesCount());
        sr.add(new SortedRanges.Range(21L, 50L));
        Assert.assertEquals((long)70L, (long)sr.getIndicesCount());
        LOG.debug((Object)sr);
        SortedRanges.SkipRangeIterator it = sr.skipRangeIterator();
        int i = 0;
        Assert.assertEquals((long)i, (long)((Long)it.next()));
        for (i = 16; i < 21; ++i) {
            Assert.assertEquals((long)i, (long)((Long)it.next()));
        }
        Assert.assertEquals((long)76L, (long)((Long)it.next()));
        Assert.assertEquals((long)77L, (long)((Long)it.next()));
    }

    @Test
    public void testRemove() {
        SortedRanges sr = new SortedRanges();
        sr.add(new SortedRanges.Range(2L, 19L));
        Assert.assertEquals((long)19L, (long)sr.getIndicesCount());
        sr.remove(new SortedRanges.Range(15L, 8L));
        Assert.assertEquals((long)13L, (long)sr.getIndicesCount());
        sr.remove(new SortedRanges.Range(6L, 5L));
        Assert.assertEquals((long)8L, (long)sr.getIndicesCount());
        sr.remove(new SortedRanges.Range(8L, 4L));
        Assert.assertEquals((long)7L, (long)sr.getIndicesCount());
        sr.add(new SortedRanges.Range(18L, 5L));
        Assert.assertEquals((long)12L, (long)sr.getIndicesCount());
        sr.add(new SortedRanges.Range(25L, 1L));
        Assert.assertEquals((long)13L, (long)sr.getIndicesCount());
        sr.remove(new SortedRanges.Range(7L, 24L));
        Assert.assertEquals((long)4L, (long)sr.getIndicesCount());
        sr.remove(new SortedRanges.Range(5L, 1L));
        Assert.assertEquals((long)3L, (long)sr.getIndicesCount());
        LOG.debug((Object)sr);
    }
}

