/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;

class ObserveableOp
extends Operation {
    private Operation op;
    private Observer observer;

    ObserveableOp(Operation op, Observer observer) {
        super(op.getType(), op.getConfig(), op.getRandom());
        this.op = op;
        this.observer = observer;
    }

    @Override
    public String toString() {
        return this.op.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<OperationOutput> run(FileSystem fs) {
        List<OperationOutput> result = null;
        try {
            if (this.observer != null) {
                this.observer.notifyStarting(this.op);
            }
            result = this.op.run(fs);
        }
        finally {
            if (this.observer != null) {
                this.observer.notifyFinished(this.op);
            }
        }
        return result;
    }

    static interface Observer {
        public void notifyStarting(Operation var1);

        public void notifyFinished(Operation var1);
    }
}

