/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.io.IOException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.server.ServerConstants;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CountRowKeys
extends Configured
implements Tool {
    public int run(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        if (args.length != 2) {
            System.out.println("Usage: CountRowKeys tableName outputPath");
            return 1;
        }
        Job job = new Job(this.getConf(), ((Object)((Object)this)).getClass().getName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setInputFormatClass(SequenceFileInputFormat.class);
        SequenceFileInputFormat.addInputPath((Job)job, (Path)new Path(ServerConstants.getTablesDir() + "/" + args[0] + "/*/*/data"));
        job.setMapperClass(MyMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(NullWritable.class);
        job.setReducerClass(MyReducer.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)CachedConfiguration.getInstance(), (Tool)new CountRowKeys(), (String[])args);
        if (res != 0) {
            System.exit(res);
        }
    }

    private static class MyReducer
    extends Reducer<Text, NullWritable, Text, Text> {
        private MyReducer() {
        }

        public void reduce(Text key, Iterable<NullWritable> values, Reducer.Context context) throws IOException {
            context.getCounter((Enum)Count.uniqueRows).increment(1L);
        }

        public static enum Count {
            uniqueRows;

        }
    }

    private static class MyMapper
    extends Mapper<Key, Value, Text, NullWritable> {
        Text k = new Text();

        private MyMapper() {
        }

        public void map(Key key, Value value, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)key.getRow(this.k), (Object)NullWritable.get());
        }
    }
}

