/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import java.util.Set;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.SecurityOperationsImpl;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.accumulo.server.security.handler.ZKAuthenticator;
import org.apache.accumulo.server.security.handler.ZKAuthorizor;
import org.apache.accumulo.server.security.handler.ZKPermHandler;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.log4j.Logger;

public class SecurityOperation {
    private static final Logger log = Logger.getLogger(SecurityOperationsImpl.class);
    protected Authorizor authorizor;
    protected Authenticator authenticator;
    protected PermissionHandler permHandle;
    private static String rootUserName = null;
    private final ZooCache zooCache;
    private final String ZKUserPath;
    protected static SecurityOperation instance;

    public static synchronized SecurityOperation getInstance() {
        String instanceId = HdfsZooInstance.getInstance().getInstanceID();
        return SecurityOperation.getInstance(instanceId, false);
    }

    public static synchronized SecurityOperation getInstance(String instanceId, boolean initialize) {
        if (instance == null) {
            instance = new SecurityOperation(SecurityOperation.getAuthorizor(instanceId, initialize), SecurityOperation.getAuthenticator(instanceId, initialize), SecurityOperation.getPermHandler(instanceId, initialize), instanceId);
        }
        return instance;
    }

    protected static Authorizor getAuthorizor(String instanceId, boolean initialize) {
        Authorizor toRet = Master.createInstanceFromPropertyName((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration(), Property.INSTANCE_SECURITY_AUTHORIZOR, Authorizor.class, ZKAuthorizor.getInstance());
        toRet.initialize(instanceId, initialize);
        return toRet;
    }

    protected static Authenticator getAuthenticator(String instanceId, boolean initialize) {
        Authenticator toRet = Master.createInstanceFromPropertyName((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration(), Property.INSTANCE_SECURITY_AUTHENTICATOR, Authenticator.class, ZKAuthenticator.getInstance());
        toRet.initialize(instanceId, initialize);
        return toRet;
    }

    protected static PermissionHandler getPermHandler(String instanceId, boolean initialize) {
        PermissionHandler toRet = Master.createInstanceFromPropertyName((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration(), Property.INSTANCE_SECURITY_PERMISSION_HANDLER, PermissionHandler.class, ZKPermHandler.getInstance());
        toRet.initialize(instanceId, initialize);
        return toRet;
    }

    public SecurityOperation(String instanceId) {
        this.ZKUserPath = "/accumulo/" + instanceId + "/users";
        this.zooCache = new ZooCache();
    }

    public SecurityOperation(Authorizor author, Authenticator authent, PermissionHandler pm, String instanceId) {
        this(instanceId);
        this.authorizor = author;
        this.authenticator = authent;
        this.permHandle = pm;
        if (!(this.authorizor.validSecurityHandlers(this.authenticator, pm) && this.authenticator.validSecurityHandlers(this.authorizor, pm) && this.permHandle.validSecurityHandlers(authent, author))) {
            throw new RuntimeException(this.authorizor + ", " + this.authenticator + ", and " + pm + " do not play nice with eachother. Please choose authentication and authorization mechanisms that are compatible with one another.");
        }
    }

    public void initializeSecurity(TCredentials credentials, String rootPrincipal, byte[] token) throws AccumuloSecurityException, ThriftSecurityException {
        this.authenticate(credentials);
        if (!credentials.getPrincipal().equals("!SYSTEM")) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.authenticator.initializeSecurity(credentials, rootPrincipal, token);
        this.authorizor.initializeSecurity(credentials, rootPrincipal);
        this.permHandle.initializeSecurity(credentials, rootPrincipal);
        try {
            this.permHandle.grantTablePermission(rootPrincipal, "!0", TablePermission.ALTER_TABLE);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized String getRootUsername() {
        if (rootUserName == null) {
            rootUserName = new String(this.zooCache.get(this.ZKUserPath));
        }
        return rootUserName;
    }

    private void authenticate(TCredentials credentials) throws ThriftSecurityException {
        if (!credentials.getInstanceId().equals(HdfsZooInstance.getInstance().getInstanceID())) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.INVALID_INSTANCEID);
        }
        if (SecurityConstants.getSystemCredentials().equals(credentials)) {
            return;
        }
        if (credentials.getPrincipal().equals("!SYSTEM")) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_CREDENTIALS);
        }
        try {
            AuthenticationToken token = this.reassembleToken(credentials);
            if (!this.authenticator.authenticateUser(credentials.getPrincipal(), token)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_CREDENTIALS);
            }
        }
        catch (AccumuloSecurityException e) {
            log.debug((Object)e);
            throw e.asThriftException();
        }
    }

    public boolean canAskAboutUser(TCredentials credentials, String user) throws ThriftSecurityException {
        if (!this.canPerformSystemActions(credentials) && !credentials.getPrincipal().equals(user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return true;
    }

    public boolean authenticateUser(TCredentials credentials, TCredentials toAuth) throws ThriftSecurityException {
        this.canAskAboutUser(credentials, toAuth.getPrincipal());
        if (credentials.equals(toAuth)) {
            return true;
        }
        try {
            AuthenticationToken token = this.reassembleToken(toAuth);
            return this.authenticator.authenticateUser(toAuth.getPrincipal(), token);
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    private AuthenticationToken reassembleToken(TCredentials toAuth) throws AccumuloSecurityException {
        String tokenClass = toAuth.getTokenClassName();
        if (this.authenticator.validTokenClass(tokenClass)) {
            return CredentialHelper.extractToken((TCredentials)toAuth);
        }
        throw new AccumuloSecurityException(toAuth.getPrincipal(), SecurityErrorCode.INVALID_TOKEN);
    }

    public Authorizations getUserAuthorizations(TCredentials credentials, String user) throws ThriftSecurityException {
        this.authenticate(credentials);
        this.targetUserExists(user);
        if (!credentials.getPrincipal().equals(user) && !this.hasSystemPermission(credentials.getPrincipal(), SystemPermission.SYSTEM, false)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        if (user.equals("!SYSTEM")) {
            return Constants.NO_AUTHS;
        }
        try {
            return this.authorizor.getCachedUserAuthorizations(user);
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public Authorizations getUserAuthorizations(TCredentials credentials) throws ThriftSecurityException {
        return this.getUserAuthorizations(credentials, credentials.getPrincipal());
    }

    private boolean hasSystemPermission(String user, SystemPermission permission, boolean useCached) throws ThriftSecurityException {
        if (user.equals(this.getRootUsername()) || user.equals("!SYSTEM")) {
            return true;
        }
        this.targetUserExists(user);
        try {
            if (useCached) {
                return this.permHandle.hasCachedSystemPermission(user, permission);
            }
            return this.permHandle.hasSystemPermission(user, permission);
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    private boolean hasTablePermission(String user, String table, TablePermission permission, boolean useCached) throws ThriftSecurityException {
        if (user.equals("!SYSTEM")) {
            return true;
        }
        this.targetUserExists(user);
        if (table.equals("!0") && permission.equals((Object)TablePermission.READ)) {
            return true;
        }
        try {
            if (useCached) {
                return this.permHandle.hasCachedTablePermission(user, table, permission);
            }
            return this.permHandle.hasTablePermission(user, table, permission);
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (TableNotFoundException e) {
            throw new ThriftSecurityException(user, SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    private boolean canAskAboutOtherUsers(TCredentials credentials, String user) throws ThriftSecurityException {
        this.authenticate(credentials);
        return credentials.getPrincipal().equals(user) || this.hasSystemPermission(credentials.getPrincipal(), SystemPermission.SYSTEM, false) || this.hasSystemPermission(credentials.getPrincipal(), SystemPermission.CREATE_USER, false) || this.hasSystemPermission(credentials.getPrincipal(), SystemPermission.ALTER_USER, false) || this.hasSystemPermission(credentials.getPrincipal(), SystemPermission.DROP_USER, false);
    }

    private void targetUserExists(String user) throws ThriftSecurityException {
        if (user.equals("!SYSTEM") || user.equals(this.getRootUsername())) {
            return;
        }
        try {
            if (!this.authenticator.userExists(user)) {
                throw new ThriftSecurityException(user, SecurityErrorCode.USER_DOESNT_EXIST);
            }
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public boolean canScan(TCredentials credentials, String table) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasTablePermission(credentials.getPrincipal(), table, TablePermission.READ, true);
    }

    public boolean canWrite(TCredentials credentials, String table) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasTablePermission(credentials.getPrincipal(), table, TablePermission.WRITE, true);
    }

    public boolean canSplitTablet(TCredentials credentials, String table) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermission(credentials.getPrincipal(), SystemPermission.ALTER_TABLE, false) || this.hasSystemPermission(credentials.getPrincipal(), SystemPermission.SYSTEM, false) || this.hasTablePermission(credentials.getPrincipal(), table, TablePermission.ALTER_TABLE, false);
    }

    public boolean canPerformSystemActions(TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermission(credentials.getPrincipal(), SystemPermission.SYSTEM, false);
    }

    public boolean canFlush(TCredentials c, String tableId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasTablePermission(c.getPrincipal(), tableId, TablePermission.WRITE, false) || this.hasTablePermission(c.getPrincipal(), tableId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canAlterTable(TCredentials c, String tableId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasTablePermission(c.getPrincipal(), tableId, TablePermission.ALTER_TABLE, false) || this.hasSystemPermission(c.getPrincipal(), SystemPermission.ALTER_TABLE, false);
    }

    public boolean canCreateTable(TCredentials c) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.CREATE_TABLE, false);
    }

    public boolean canRenameTable(TCredentials c, String tableId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.ALTER_TABLE, false) || this.hasTablePermission(c.getPrincipal(), tableId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canCloneTable(TCredentials c, String tableId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.CREATE_TABLE, false) && this.hasTablePermission(c.getPrincipal(), tableId, TablePermission.READ, false);
    }

    public boolean canDeleteTable(TCredentials c, String tableId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.DROP_TABLE, false) || this.hasTablePermission(c.getPrincipal(), tableId, TablePermission.DROP_TABLE, false);
    }

    public boolean canOnlineOfflineTable(TCredentials c, String tableId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.SYSTEM, false) || this.hasSystemPermission(c.getPrincipal(), SystemPermission.ALTER_TABLE, false) || this.hasTablePermission(c.getPrincipal(), tableId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canMerge(TCredentials c, String tableId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.SYSTEM, false) || this.hasSystemPermission(c.getPrincipal(), SystemPermission.ALTER_TABLE, false) || this.hasTablePermission(c.getPrincipal(), tableId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canDeleteRange(TCredentials c, String tableId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.SYSTEM, false) || this.hasTablePermission(c.getPrincipal(), tableId, TablePermission.WRITE, false);
    }

    public boolean canBulkImport(TCredentials c, String tableId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasTablePermission(c.getPrincipal(), tableId, TablePermission.BULK_IMPORT, false);
    }

    public boolean canCompact(TCredentials c, String tableId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.ALTER_TABLE, false) || this.hasTablePermission(c.getPrincipal(), tableId, TablePermission.ALTER_TABLE, false) || this.hasTablePermission(c.getPrincipal(), tableId, TablePermission.WRITE, false);
    }

    public boolean canChangeAuthorizations(TCredentials c, String user) throws ThriftSecurityException {
        this.authenticate(c);
        if (user.equals("!SYSTEM")) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.ALTER_USER, false);
    }

    public boolean canChangePassword(TCredentials c, String user) throws ThriftSecurityException {
        this.authenticate(c);
        if (user.equals("!SYSTEM")) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return c.getPrincipal().equals(user) || this.hasSystemPermission(c.getPrincipal(), SystemPermission.ALTER_USER, false);
    }

    public boolean canCreateUser(TCredentials c, String user) throws ThriftSecurityException {
        this.authenticate(c);
        if (user.equals("!SYSTEM")) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.CREATE_USER, false);
    }

    public boolean canDropUser(TCredentials c, String user) throws ThriftSecurityException {
        this.authenticate(c);
        if (user.equals(this.getRootUsername()) || user.equals("!SYSTEM")) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.DROP_USER, false);
    }

    public boolean canGrantSystem(TCredentials c, String user, SystemPermission sysPerm) throws ThriftSecurityException {
        this.authenticate(c);
        if (user.equals("!SYSTEM")) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        if (sysPerm.equals((Object)SystemPermission.GRANT)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.GRANT_INVALID);
        }
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.GRANT, false);
    }

    public boolean canGrantTable(TCredentials c, String user, String table) throws ThriftSecurityException {
        this.authenticate(c);
        if (user.equals("!SYSTEM")) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.ALTER_TABLE, false) || this.hasTablePermission(c.getPrincipal(), table, TablePermission.GRANT, false);
    }

    public boolean canRevokeSystem(TCredentials c, String user, SystemPermission sysPerm) throws ThriftSecurityException {
        this.authenticate(c);
        if (user.equals(this.getRootUsername()) || user.equals("!SYSTEM")) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        if (sysPerm.equals((Object)SystemPermission.GRANT)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.GRANT_INVALID);
        }
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.GRANT, false);
    }

    public boolean canRevokeTable(TCredentials c, String user, String table) throws ThriftSecurityException {
        this.authenticate(c);
        if (user.equals("!SYSTEM")) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this.hasSystemPermission(c.getPrincipal(), SystemPermission.ALTER_TABLE, false) || this.hasTablePermission(c.getPrincipal(), table, TablePermission.GRANT, false);
    }

    public void changeAuthorizations(TCredentials credentials, String user, Authorizations authorizations) throws ThriftSecurityException {
        if (!this.canChangeAuthorizations(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.authorizor.changeAuthorizations(user, authorizations);
            log.info((Object)("Changed authorizations for user " + user + " at the request of user " + credentials.getPrincipal()));
        }
        catch (AccumuloSecurityException ase) {
            throw ase.asThriftException();
        }
    }

    public void changePassword(TCredentials credentials, TCredentials toChange) throws ThriftSecurityException {
        if (!this.canChangePassword(credentials, toChange.getPrincipal())) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            AuthenticationToken token = this.reassembleToken(toChange);
            this.authenticator.changePassword(toChange.getPrincipal(), token);
            log.info((Object)("Changed password for user " + toChange.getPrincipal() + " at the request of user " + credentials.getPrincipal()));
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void createUser(TCredentials credentials, TCredentials newUser, Authorizations authorizations) throws ThriftSecurityException {
        if (!this.canCreateUser(credentials, newUser.getPrincipal())) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            AuthenticationToken token = this.reassembleToken(newUser);
            this.authenticator.createUser(newUser.getPrincipal(), token);
            this.authorizor.initUser(newUser.getPrincipal());
            this.permHandle.initUser(newUser.getPrincipal());
            log.info((Object)("Created user " + newUser.getPrincipal() + " at the request of user " + credentials.getPrincipal()));
            if (this.canChangeAuthorizations(credentials, newUser.getPrincipal())) {
                this.authorizor.changeAuthorizations(newUser.getPrincipal(), authorizations);
            }
        }
        catch (AccumuloSecurityException ase) {
            throw ase.asThriftException();
        }
    }

    public void dropUser(TCredentials credentials, String user) throws ThriftSecurityException {
        if (!this.canDropUser(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            this.authorizor.dropUser(user);
            this.authenticator.dropUser(user);
            this.permHandle.cleanUser(user);
            log.info((Object)("Deleted user " + user + " at the request of user " + credentials.getPrincipal()));
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void grantSystemPermission(TCredentials credentials, String user, SystemPermission permissionById) throws ThriftSecurityException {
        if (!this.canGrantSystem(credentials, user, permissionById)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.grantSystemPermission(user, permissionById);
            log.info((Object)("Granted system permission " + permissionById + " for user " + user + " at the request of user " + credentials.getPrincipal()));
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void grantTablePermission(TCredentials c, String user, String tableId, TablePermission permission) throws ThriftSecurityException {
        if (!this.canGrantTable(c, user, tableId)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.grantTablePermission(user, tableId, permission);
            log.info((Object)("Granted table permission " + permission + " for user " + user + " on the table " + tableId + " at the request of user " + c.getPrincipal()));
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (TableNotFoundException e) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    public void revokeSystemPermission(TCredentials credentials, String user, SystemPermission permission) throws ThriftSecurityException {
        if (!this.canRevokeSystem(credentials, user, permission)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.revokeSystemPermission(user, permission);
            log.info((Object)("Revoked system permission " + permission + " for user " + user + " at the request of user " + credentials.getPrincipal()));
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void revokeTablePermission(TCredentials c, String user, String tableId, TablePermission permission) throws ThriftSecurityException {
        if (!this.canRevokeTable(c, user, tableId)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.revokeTablePermission(user, tableId, permission);
            log.info((Object)("Revoked table permission " + permission + " for user " + user + " on the table " + tableId + " at the request of user " + c.getPrincipal()));
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (TableNotFoundException e) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    public boolean hasSystemPermission(TCredentials credentials, String user, SystemPermission permissionById) throws ThriftSecurityException {
        if (!this.canAskAboutOtherUsers(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this.hasSystemPermission(user, permissionById, false);
    }

    public boolean hasTablePermission(TCredentials credentials, String user, String tableId, TablePermission permissionById) throws ThriftSecurityException {
        if (!this.canAskAboutOtherUsers(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this.hasTablePermission(user, tableId, permissionById, false);
    }

    public Set<String> listUsers(TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        try {
            return this.authenticator.listUsers();
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void deleteTable(TCredentials credentials, String tableId) throws ThriftSecurityException {
        if (!this.canDeleteTable(credentials, tableId)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            this.permHandle.cleanTablePermissions(tableId);
        }
        catch (AccumuloSecurityException e) {
            e.setUser(credentials.getPrincipal());
            throw e.asThriftException();
        }
        catch (TableNotFoundException e) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    public boolean canExport(TCredentials credentials, String tableId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasTablePermission(credentials.getPrincipal(), tableId, TablePermission.READ, false);
    }

    public boolean canImport(TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermission(credentials.getPrincipal(), SystemPermission.CREATE_TABLE, false);
    }
}

