/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.monitor.servlets;

import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.state.DeadServerList;
import org.apache.accumulo.server.monitor.LogService;
import org.apache.accumulo.server.monitor.servlets.BasicServlet;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.log4j.Logger;

public class OperationServlet
extends BasicServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected String getTitle(HttpServletRequest req) {
        return "Operations";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block17: {
            String redir = null;
            try {
                String operation = req.getParameter("action");
                redir = req.getParameter("redir");
                if (redir != null) {
                    redir = OperationServlet.decode(redir);
                }
                if (operation == null) break block17;
                for (Class<?> subclass : OperationServlet.class.getClasses()) {
                    WebOperation op;
                    Object t;
                    try {
                        t = subclass.newInstance();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (!(t instanceof WebOperation) || !(op = (WebOperation)t).getClass().getSimpleName().equalsIgnoreCase(operation + "Operation")) continue;
                    op.execute(req, resp, log);
                    break;
                }
            }
            catch (Throwable t) {
                log.error((Object)t, t);
            }
            finally {
                try {
                    if (redir != null) {
                        resp.sendRedirect(redir);
                    } else {
                        resp.sendRedirect("/");
                    }
                    resp.flushBuffer();
                }
                catch (Throwable t) {
                    log.error((Object)t, t);
                }
            }
        }
    }

    public static class ClearDeadServerOperation
    implements WebOperation {
        @Override
        public void execute(HttpServletRequest req, HttpServletResponse resp, Logger log) {
            String server = BasicServlet.decode(req.getParameter("server"));
            Instance inst = HdfsZooInstance.getInstance();
            DeadServerList obit = new DeadServerList(ZooUtil.getRoot((Instance)inst) + "/dead/tservers");
            obit.delete(server);
        }
    }

    public static class ToggleLegendOperation
    implements WebOperation {
        @Override
        public void execute(HttpServletRequest req, HttpServletResponse resp, Logger log) throws Exception {
            String page = req.getParameter("page");
            String table = req.getParameter("table");
            String show = req.getParameter("show");
            if (table == null || page == null || show == null) {
                return;
            }
            resp.addCookie(new Cookie("tableLegend." + page + "." + table + "." + "show", show));
        }
    }

    public static class SortTableOperation
    implements WebOperation {
        @Override
        public void execute(HttpServletRequest req, HttpServletResponse resp, Logger log) throws IOException {
            String page = req.getParameter("page");
            String table = req.getParameter("table");
            String asc = req.getParameter("asc");
            String col = req.getParameter("col");
            if (table == null || page == null || asc == null && col == null) {
                return;
            }
            if (asc == null) {
                resp.addCookie(new Cookie("tableSort." + page + "." + table + "." + "sortCol", col));
            } else {
                resp.addCookie(new Cookie("tableSort." + page + "." + table + "." + "sortAsc", asc));
            }
        }
    }

    public static class ClearProblemOperation
    implements WebOperation {
        @Override
        public void execute(HttpServletRequest req, HttpServletResponse resp, Logger log) {
            String ptype;
            String table = req.getParameter("table");
            String resource = req.getParameter("resource");
            if (resource != null) {
                resource = BasicServlet.decode(resource);
            }
            if ((ptype = req.getParameter("ptype")) != null) {
                ptype = BasicServlet.decode(ptype);
            }
            try {
                ProblemReports.getInstance().deleteProblemReport(table, ProblemType.valueOf(ptype), resource);
            }
            catch (Exception e) {
                log.error((Object)("Failed to delete problem reports for table " + table), (Throwable)e);
            }
        }
    }

    public static class ClearTableProblemsOperation
    implements WebOperation {
        @Override
        public void execute(HttpServletRequest req, HttpServletResponse resp, Logger log) {
            String table = req.getParameter("table");
            try {
                ProblemReports.getInstance().deleteProblemReports(table);
            }
            catch (Exception e) {
                log.error((Object)("Failed to delete problem reports for table " + table), (Throwable)e);
            }
        }
    }

    public static class ClearLogOperation
    implements WebOperation {
        @Override
        public void execute(HttpServletRequest req, HttpServletResponse resp, Logger log) {
            LogService.getInstance().clear();
        }
    }

    public static class RefreshOperation
    implements WebOperation {
        @Override
        public void execute(HttpServletRequest req, HttpServletResponse resp, Logger log) {
            String value = req.getParameter("value");
            resp.addCookie(new Cookie("page.refresh.rate", value == null ? "5" : value));
        }
    }

    private static interface WebOperation {
        public void execute(HttpServletRequest var1, HttpServletResponse var2, Logger var3) throws Exception;
    }
}

