/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.monitor.servlets;

import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.accumulo.server.monitor.DedupedLogEvent;
import org.apache.accumulo.server.monitor.LogService;
import org.apache.accumulo.server.monitor.servlets.BasicServlet;
import org.apache.accumulo.server.monitor.util.Table;
import org.apache.accumulo.server.monitor.util.celltypes.DateTimeType;
import org.apache.accumulo.server.monitor.util.celltypes.StringType;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class LogServlet
extends BasicServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected String getTitle(HttpServletRequest req) {
        return "Recent Logs";
    }

    @Override
    protected void pageBody(HttpServletRequest req, HttpServletResponse resp, StringBuilder sb) {
        boolean clear = true;
        SimpleDateFormat fmt = new SimpleDateFormat("dd HH:mm:ss,SSSS");
        Table logTable = new Table("logTable", "Recent&nbsp;Logs");
        logTable.addSortableColumn("Time", new DateTimeType(fmt), null);
        logTable.addSortableColumn("Application");
        logTable.addSortableColumn("Count");
        logTable.addSortableColumn("Level", new LogLevelType(), null);
        logTable.addSortableColumn("Message");
        for (DedupedLogEvent dev : LogService.getInstance().getEvents()) {
            clear = false;
            LoggingEvent ev = dev.getEvent();
            Object application = ev.getMDC("application");
            if (application == null) {
                application = "";
            }
            String msg = ev.getMessage().toString();
            StringBuilder text = new StringBuilder();
            for (int i = 0; i < msg.length(); ++i) {
                char c = msg.charAt(i);
                switch (Character.getType(c)) {
                    case 0: 
                    case 6: 
                    case 13: 
                    case 18: {
                        c = '?';
                    }
                }
                text.append(c);
            }
            msg = text.toString();
            if (ev.getThrowableStrRep() != null) {
                for (String line : ev.getThrowableStrRep()) {
                    msg = msg + "\n\t" + line;
                }
            }
            msg = LogServlet.sanitize(msg.trim());
            msg = "<pre class='logevent'>" + msg + "</pre>";
            logTable.addRow(ev.getTimeStamp(), application, dev.getCount(), ev.getLevel(), msg);
        }
        if (!clear) {
            logTable.setSubCaption("<a href='/op?action=clearLog&redir=" + LogServlet.currentPage(req) + "'>Clear&nbsp;All&nbsp;Events</a>");
        }
        logTable.generate(req, sb);
        if (!clear) {
            sb.append("<div class='center'><a href='/op?action=clearLog&redir=").append(LogServlet.currentPage(req)).append("'>Clear&nbsp;All&nbsp;Events</a></div>\n");
        }
    }

    private static class LogLevelType
    extends StringType<Level> {
        private LogLevelType() {
        }

        @Override
        public String alignment() {
            return "center";
        }

        @Override
        public String format(Object obj) {
            if (obj == null) {
                return "-";
            }
            Level l = (Level)obj;
            if (l.equals((Object)Level.ERROR) || l.equals((Object)Level.FATAL)) {
                return "<div class='error'>" + l.toString() + "</div>";
            }
            if (l.equals((Object)Level.WARN)) {
                return "<div class='warning'>" + l.toString() + "</div>";
            }
            return l.toString();
        }
    }
}

