/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public class LineageInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<DependencyKey, Dependency> index = Collections.synchronizedMap(new LinkedHashMap());

    public Dependency getDependency(DataContainer dc, FieldSchema col) {
        return this.index.get(new DependencyKey(dc, col));
    }

    public void putDependency(DataContainer dc, FieldSchema col, Dependency dep) {
        this.index.put(new DependencyKey(dc, col), dep);
    }

    public Set<Map.Entry<DependencyKey, Dependency>> entrySet() {
        return this.index.entrySet();
    }

    public void clear() {
        this.index.clear();
    }

    public static class Dependency
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private DependencyType type;
        private String expr;
        private List<BaseColumnInfo> baseCols;

        public DependencyType getType() {
            return this.type;
        }

        public void setType(DependencyType type) {
            this.type = type;
        }

        public String getExpr() {
            return this.expr;
        }

        public void setExpr(String expr) {
            this.expr = expr;
        }

        public List<BaseColumnInfo> getBaseCols() {
            return this.baseCols;
        }

        public void setBaseCols(List<BaseColumnInfo> baseCols) {
            this.baseCols = baseCols;
        }

        public String toString() {
            return "[" + (Object)((Object)this.type) + "]" + this.baseCols;
        }
    }

    public static class TableAliasInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String alias;
        private Table table;

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public Table getTable() {
            return this.table;
        }

        public void setTable(Table table) {
            this.table = table;
        }

        public String toString() {
            return this.table.getDbName() + "." + this.table.getTableName() + "(" + this.alias + ")";
        }
    }

    public static class BaseColumnInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private TableAliasInfo tabAlias;
        private FieldSchema column;

        public TableAliasInfo getTabAlias() {
            return this.tabAlias;
        }

        public void setTabAlias(TableAliasInfo tabAlias) {
            this.tabAlias = tabAlias;
        }

        public FieldSchema getColumn() {
            return this.column;
        }

        public void setColumn(FieldSchema column) {
            this.column = column;
        }

        public String toString() {
            return this.tabAlias + ":" + this.column;
        }
    }

    public static class DependencyKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final DataContainer dc;
        private final FieldSchema fld;

        public DependencyKey(DataContainer dc, FieldSchema fld) {
            this.dc = dc;
            this.fld = fld;
        }

        public DataContainer getDataContainer() {
            return this.dc;
        }

        public FieldSchema getFieldSchema() {
            return this.fld;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dc == null ? 0 : this.dc.hashCode());
            result = 31 * result + (this.fld == null ? 0 : this.fld.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyKey other = (DependencyKey)obj;
            if (this.dc != other.dc) {
                return false;
            }
            return this.fld == other.fld;
        }

        public String toString() {
            return this.dc + ":" + this.fld;
        }
    }

    public static class DataContainer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Table tab;
        private final Partition part;

        public DataContainer(Table tab) {
            this.tab = tab;
            this.part = null;
        }

        public DataContainer(Table tab, Partition part) {
            this.tab = tab;
            this.part = part;
        }

        public boolean isPartition() {
            return this.part != null;
        }

        public Table getTable() {
            return this.tab;
        }

        public Partition getPartition() {
            return this.part;
        }

        public String toString() {
            return this.isPartition() ? this.part.getDbName() + "." + this.part.getTableName() + "@" + this.part.getValues() : this.tab.getDbName() + "." + this.tab.getTableName();
        }
    }

    public static enum DependencyType {
        SIMPLE,
        EXPRESSION,
        SCRIPT;

    }
}

