/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashSet;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class VectorMapJoinLeftSemiLongOperator
extends VectorMapJoinLeftSemiGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinInnerBigOnlyLongOperator.class.getName());
    private static final String CLASS_NAME = VectorMapJoinLeftSemiLongOperator.class.getName();
    private transient VectorMapJoinLongHashSet hashSet;
    private transient boolean useMinMax;
    private transient long min;
    private transient long max;
    private transient int singleJoinColumn;

    public VectorMapJoinLeftSemiLongOperator() {
    }

    public VectorMapJoinLeftSemiLongOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.singleJoinColumn = this.bigTableKeyColumnMap[0];
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashSet = (VectorMapJoinLongHashSet)this.vectorMapJoinHashTable;
                this.useMinMax = this.hashSet.useMinMax();
                if (this.useMinMax) {
                    this.min = this.hashSet.min();
                    this.max = this.hashSet.max();
                }
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " empty"));
                }
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            LongColumnVector joinColVector = (LongColumnVector)batch.cols[this.singleJoinColumn];
            long[] vector = joinColVector.vector;
            boolean allKeyInputColumnsRepeating = joinColVector.isRepeating;
            if (allKeyInputColumnsRepeating) {
                long key = vector[0];
                JoinUtil.JoinResult joinResult = this.useMinMax && (key < this.min || key > this.max) ? JoinUtil.JoinResult.NOMATCH : this.hashSet.contains(key, this.hashSetResults[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name()));
                }
                this.finishLeftSemiRepeated(batch, joinResult, this.hashSetResults[0]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated"));
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashSetResultCount = 0;
                int allMatchCount = 0;
                int spillCount = 0;
                long saveKey = 0L;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block21: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    long currentKey = vector[batchIndex];
                    if (!haveSaveKey || currentKey != saveKey) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    break;
                                }
                                case SPILL: {
                                    ++hashSetResultCount;
                                    break;
                                }
                            }
                        }
                        haveSaveKey = true;
                        saveKey = currentKey;
                        saveJoinResult = this.useMinMax && (currentKey < this.min || currentKey > this.max) ? JoinUtil.JoinResult.NOMATCH : this.hashSet.contains(currentKey, this.hashSetResults[hashSetResultCount]);
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashSetResultCount;
                                ++spillCount;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block21;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashSetResultCount;
                            ++spillCount;
                            continue block21;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            break;
                        }
                        case SPILL: {
                            ++hashSetResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(CLASS_NAME + " allMatchs " + VectorMapJoinLeftSemiLongOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " spills " + VectorMapJoinLeftSemiLongOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinLeftSemiLongOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashSetResults, 0, hashSetResultCount))));
                }
                this.finishLeftSemi(batch, allMatchCount, spillCount, this.hashSetResults);
            }
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

