/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public abstract class FuncLongToString
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int inputCol;
    private int outputCol;
    protected transient byte[] bytes;

    FuncLongToString(int inputCol, int outputCol) {
        this.inputCol = inputCol;
        this.outputCol = outputCol;
        this.bytes = new byte[64];
    }

    FuncLongToString() {
        this.bytes = new byte[64];
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.inputCol];
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector = inputColVector.vector;
        BytesColumnVector outV = (BytesColumnVector)batch.cols[this.outputCol];
        outV.initBuffer();
        if (n == 0) {
            return;
        }
        if (inputColVector.noNulls) {
            outV.noNulls = true;
            if (inputColVector.isRepeating) {
                outV.isRepeating = true;
                this.prepareResult(0, vector, outV);
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.prepareResult(i, vector, outV);
                }
                outV.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    this.prepareResult(i, vector, outV);
                }
                outV.isRepeating = false;
            }
        } else {
            outV.noNulls = false;
            if (inputColVector.isRepeating) {
                outV.isRepeating = true;
                outV.isNull[0] = inputColVector.isNull[0];
                if (!inputColVector.isNull[0]) {
                    this.prepareResult(0, vector, outV);
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!inputColVector.isNull[i]) {
                        this.prepareResult(i, vector, outV);
                    }
                    outV.isNull[i] = inputColVector.isNull[i];
                }
                outV.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    if (!inputColVector.isNull[i]) {
                        this.prepareResult(i, vector, outV);
                    }
                    outV.isNull[i] = inputColVector.isNull[i];
                }
                outV.isRepeating = false;
            }
        }
    }

    abstract void prepareResult(int var1, long[] var2, BytesColumnVector var3);

    @Override
    public int getOutputColumn() {
        return this.outputCol;
    }

    public int getOutputCol() {
        return this.outputCol;
    }

    public void setOutputCol(int outputCol) {
        this.outputCol = outputCol;
    }

    public int getInputCol() {
        return this.inputCol;
    }

    public void setInputCol(int inputCol) {
        this.inputCol = inputCol;
    }

    @Override
    public String getOutputType() {
        return "String";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY).build();
    }
}

