/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;

public class TableCfWALEntryFilter
implements WALEntryFilter {
    private static final Log LOG = LogFactory.getLog(TableCfWALEntryFilter.class);
    private final ReplicationPeer peer;

    public TableCfWALEntryFilter(ReplicationPeer peer) {
        this.peer = peer;
    }

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        TableName tabName = entry.getKey().getTablename();
        ArrayList<Cell> cells = entry.getEdit().getCells();
        Map tableCFs = null;
        try {
            tableCFs = this.peer.getTableCFs();
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("should not happen: can't get tableCFs for peer " + this.peer.getId() + ", degenerate as if it's not configured by keeping tableCFs==null"));
        }
        int size = cells.size();
        if (tableCFs != null && !tableCFs.containsKey(tabName)) {
            return null;
        }
        List cfs = tableCFs == null ? null : (List)tableCFs.get(tabName);
        for (int i = size - 1; i >= 0; --i) {
            Cell cell = cells.get(i);
            if (cfs == null || cfs.contains(Bytes.toString((byte[])cell.getFamily()))) continue;
            cells.remove(i);
        }
        if (cells.size() < size / 2) {
            cells.trimToSize();
        }
        return entry;
    }
}

