/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.util.StringUtil;
import org.apache.hadoop.io.Text;

public class LocalityGroupUtil {
    public static final Set<ByteSequence> EMPTY_CF_SET = Collections.emptySet();

    public static Set<ByteSequence> families(Collection<Column> columns) {
        HashSet<ByteSequence> result = new HashSet<ByteSequence>(columns.size());
        for (Column col : columns) {
            result.add(new ArrayByteSequence(col.getColumnFamily()));
        }
        return result;
    }

    public static Map<String, Set<ByteSequence>> getLocalityGroups(AccumuloConfiguration acuconf) throws LocalityGroupConfigurationError {
        String[] groups;
        HashMap<String, Set<ByteSequence>> result = new HashMap<String, Set<ByteSequence>>();
        for (String group : groups = acuconf.get(Property.TABLE_LOCALITY_GROUPS).split(",")) {
            if (group.length() <= 0) continue;
            result.put(group, new HashSet());
        }
        HashSet<ByteSequence> all = new HashSet<ByteSequence>();
        for (Map.Entry<String, String> entry : acuconf) {
            String property = entry.getKey();
            String value = entry.getValue();
            String prefix = Property.TABLE_LOCALITY_GROUP_PREFIX.getKey();
            if (!property.startsWith(prefix)) continue;
            String group = property.substring(prefix.length());
            String[] parts = group.split("\\.");
            if (!result.containsKey(group = parts[0]) || parts.length != 1) continue;
            Set<ByteSequence> colFamsSet = LocalityGroupUtil.decodeColumnFamilies(value);
            if (!Collections.disjoint(all, colFamsSet)) {
                colFamsSet.retainAll(all);
                throw new LocalityGroupConfigurationError("Column families " + colFamsSet + " in group " + group + " is already used by another locality group");
            }
            all.addAll(colFamsSet);
            result.put(group, colFamsSet);
        }
        return result;
    }

    public static Set<ByteSequence> decodeColumnFamilies(String colFams) throws LocalityGroupConfigurationError {
        HashSet<ByteSequence> colFamsSet = new HashSet<ByteSequence>();
        for (String family : colFams.split(",")) {
            ByteSequence cfbs = LocalityGroupUtil.decodeColumnFamily(family);
            colFamsSet.add(cfbs);
        }
        return colFamsSet;
    }

    public static ByteSequence decodeColumnFamily(String colFam) throws LocalityGroupConfigurationError {
        byte[] output = new byte[colFam.length()];
        int pos = 0;
        for (int i = 0; i < colFam.length(); ++i) {
            char c = colFam.charAt(i);
            if (c == '\\') {
                if (++i >= colFam.length()) {
                    throw new LocalityGroupConfigurationError("Expected 'x' or '' after ''  in " + colFam);
                }
                char nc = colFam.charAt(i);
                switch (nc) {
                    case '\\': {
                        output[pos++] = 92;
                        break;
                    }
                    case 'x': {
                        output[pos++] = (byte)(0xFF & Integer.parseInt(colFam.substring(++i, i + 2), 16));
                        ++i;
                        break;
                    }
                    default: {
                        throw new LocalityGroupConfigurationError("Expected 'x' or '' after ''  in " + colFam);
                    }
                }
                continue;
            }
            output[pos++] = (byte)(0xFF & c);
        }
        return new ArrayByteSequence(output, 0, pos);
    }

    public static String encodeColumnFamilies(Set<Text> colFams) {
        TreeSet<String> ecfs = new TreeSet<String>();
        StringBuilder sb = new StringBuilder();
        for (Text text : colFams) {
            String ecf = LocalityGroupUtil.encodeColumnFamily(sb, text.getBytes(), 0, text.getLength());
            ecfs.add(ecf);
        }
        return StringUtil.join(ecfs, ",");
    }

    public static String encodeColumnFamily(ByteSequence bs) {
        return LocalityGroupUtil.encodeColumnFamily(new StringBuilder(), bs.getBackingArray(), bs.offset(), bs.length());
    }

    private static String encodeColumnFamily(StringBuilder sb, byte[] ba, int offset, int len) {
        sb.setLength(0);
        for (int i = 0; i < len; ++i) {
            int c = 0xFF & ba[i];
            if (c == 92) {
                sb.append("\\\\");
                continue;
            }
            if (c >= 32 && c <= 126 && c != 44) {
                sb.append((char)c);
                continue;
            }
            sb.append("\\x").append(String.format("%02X", c));
        }
        String ecf = sb.toString();
        return ecf;
    }

    public static class LocalityGroupConfigurationError
    extends AccumuloException {
        LocalityGroupConfigurationError(String why) {
            super(why);
        }
    }
}

