/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.TabletLocatorImpl;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

public class RootTabletLocator
extends TabletLocator {
    private Instance instance;

    RootTabletLocator(Instance instance) {
        this.instance = instance;
    }

    @Override
    public void binMutations(List<Mutation> mutations, Map<String, TabletLocator.TabletServerMutations> binnedMutations, List<Mutation> failures, TCredentials credentials) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Range> binRanges(List<Range> ranges, Map<String, Map<KeyExtent, List<Range>>> binnedRanges, TCredentials credentials) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String rootTabletLocation = this.instance.getRootTabletLocation();
        if (rootTabletLocation != null) {
            for (Range range : ranges) {
                TabletLocatorImpl.addRange(binnedRanges, rootTabletLocation, Constants.ROOT_TABLET_EXTENT, range);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void invalidateCache(KeyExtent failedExtent) {
    }

    @Override
    public void invalidateCache(Collection<KeyExtent> keySet) {
    }

    @Override
    public void invalidateCache(String server) {
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public TabletLocator.TabletLocation locateTablet(Text row, boolean skipRow, boolean retry, TCredentials credentials) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        if (skipRow) {
            row = new Text(row);
            row.append(new byte[]{0}, 0, 1);
        }
        if (!Constants.ROOT_TABLET_EXTENT.contains((BinaryComparable)row)) {
            throw new AccumuloException("Tried to locate row out side of root tablet " + row);
        }
        String location = this.instance.getRootTabletLocation();
        while (retry && location == null) {
            UtilWaitThread.sleep(500L);
            location = this.instance.getRootTabletLocation();
        }
        if (location != null) {
            return new TabletLocator.TabletLocation(Constants.ROOT_TABLET_EXTENT, location);
        }
        return null;
    }
}

