/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import sdsu.util.CharQueue;

public class UnicodeReader
extends FilterReader {
    private boolean isBad = false;
    private boolean hadEOF = false;

    public UnicodeReader(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public UnicodeReader(Reader reader) {
        super(reader);
        if (!(this.in instanceof PushbackReader)) {
            this.in = new PushbackReader(this.in);
        }
    }

    public boolean bad() {
        return false;
    }

    public boolean eof() throws IOException {
        if (this.hadEOF) {
            return true;
        }
        int n = this.nextNonWhiteSpaceCharacter();
        if (n == -1) {
            this.hadEOF = true;
            return true;
        }
        PushbackReader pushbackReader = (PushbackReader)this.in;
        pushbackReader.unread(n);
        return false;
    }

    public void flushLine() throws IOException {
        this.readLine();
    }

    public boolean hadEof() throws IOException {
        return this.hadEOF;
    }

    private int nextNonWhiteSpaceCharacter() throws IOException {
        int n;
        while ((n = this.in.read()) == 32 || n == 9 || n == 13 || n == 10) {
        }
        return n;
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.in.read(cArray, n, n2);
        if (n3 < 0) {
            this.hadEOF = true;
        }
        return n3;
    }

    public boolean readBoolean() throws IOException {
        String string = this.readWord();
        if (string == null) {
            throw new NumberFormatException("Error in reading boolean: no string input");
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        throw new NumberFormatException("Expected true or false, but got " + string);
    }

    public char readChar() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            this.hadEOF = true;
        }
        return (char)n;
    }

    /*
     * Unable to fully structure code
     */
    public double readDouble() throws IOException {
        block19: {
            var1_1 = (PushbackReader)this.in;
            var2_2 = 0.0;
            var4_3 = -1;
            var5_4 = 1;
            var6_5 = 0;
            var4_3 = this.nextNonWhiteSpaceCharacter();
            switch (var4_3) {
                case 45: {
                    var5_4 = -1;
                    var4_3 = var1_1.read();
                    ** GOTO lbl20
                }
                case 43: {
                    var4_3 = var1_1.read();
                    ** GOTO lbl20
                }
                default: {
                    if (var4_3 < 48) ** break;
                }
            }
lbl-1000:
            // 1 sources

            {
                var2_2 = var2_2 * 10.0 + (double)(var4_3 - 48);
                var4_3 = var1_1.read();
                ++var6_5;
lbl20:
                // 3 sources

                if (var4_3 < 48) break;
                ** while (var4_3 <= 57)
            }
lbl22:
            // 3 sources

            if (var4_3 == 46) {
                var7_6 = 0.1;
                var4_3 = var1_1.read();
                while (var4_3 >= 48 && var4_3 <= 57) {
                    var2_2 += (double)(var4_3 - 48) * var7_6;
                    var7_6 /= 10.0;
                    var4_3 = var1_1.read();
                    ++var6_5;
                }
            }
            if (var6_5 == 0) {
                throw new NumberFormatException("Next token does not have valid decimal value. Token read so far: " + var2_2 * (double)var5_4);
            }
            if (var4_3 != 101 && var4_3 != 69) break block19;
            var7_6 = 0.0;
            var9_7 = 1;
            var6_5 = 0;
            var4_3 = var1_1.read();
            switch (var4_3) {
                case 45: {
                    var9_7 = -1;
                    var4_3 = var1_1.read();
                    ** GOTO lbl51
                }
                case 43: {
                    var4_3 = var1_1.read();
                    ** GOTO lbl51
                }
                default: {
                    if (var4_3 < 48) ** break;
                }
            }
lbl-1000:
            // 1 sources

            {
                var7_6 = var7_6 * 10.0 + (double)(var4_3 - 48);
                var4_3 = var1_1.read();
                ++var6_5;
lbl51:
                // 3 sources

                if (var4_3 < 48) break;
                ** while (var4_3 <= 57)
            }
lbl53:
            // 3 sources

            if (var7_6 != 0.0) {
                try {
                    var2_2 *= Math.pow(10.0, var7_6 * (double)var9_7);
                }
                catch (Exception v0) {
                    var2_2 = 0.0;
                    var5_4 = 1;
                }
            }
            if (var6_5 == 0) {
                throw new NumberFormatException("Invalid exponent format for: " + var2_2 * (double)var5_4);
            }
        }
        if (var4_3 < 0) {
            this.hadEOF = true;
        } else {
            var1_1.unread(var4_3);
        }
        return var2_2 * (double)var5_4;
    }

    public float readFloat() throws IOException {
        return (float)this.readDouble();
    }

    public void readFully(char[] cArray) throws IOException {
        this.readFully(cArray, 0, cArray.length);
    }

    public void readFully(char[] cArray, int n, int n2) throws IOException {
        Reader reader = this.in;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = reader.read(cArray, n + n3, n2 - n3);
            if (n4 < 0) {
                this.hadEOF = true;
            }
            n3 += n4;
        }
    }

    public int readInt() throws IOException {
        return (int)this.readLong();
    }

    public String readLine() throws IOException {
        int n;
        if (this.hadEOF) {
            return null;
        }
        PushbackReader pushbackReader = (PushbackReader)this.in;
        CharQueue charQueue = new CharQueue(126);
        block4: while (true) {
            n = pushbackReader.read();
            switch (n) {
                case 13: {
                    int n2 = pushbackReader.read();
                    if (n2 == 10) break block4;
                    pushbackReader.unread(n2);
                    break block4;
                }
                default: {
                    charQueue.enqueue((char)n);
                    continue block4;
                }
                case -1: 
                case 10: 
            }
            break;
        }
        if (n == -1) {
            this.hadEOF = true;
        }
        if (charQueue.isEmpty()) {
            return null;
        }
        return charQueue.toString();
    }

    /*
     * Unable to fully structure code
     */
    public long readLong() throws IOException {
        if (this.hadEOF) {
            return 0L;
        }
        var1_1 = (PushbackReader)this.in;
        var2_2 = 0L;
        var4_3 = -1;
        var5_4 = 1L;
        var7_5 = 0;
        var4_3 = this.nextNonWhiteSpaceCharacter();
        switch (var4_3) {
            case 45: {
                var5_4 = -1L;
                var4_3 = var1_1.read();
                ** GOTO lbl25
            }
            case 43: {
                var4_3 = var1_1.read();
                ** GOTO lbl25
            }
            case -1: {
                this.hadEOF = true;
                return 0L;
            }
            default: {
                if (var4_3 < 48) ** break;
            }
        }
lbl-1000:
        // 1 sources

        {
            var2_2 = var2_2 * 10L + (long)(var4_3 - 48);
            var4_3 = var1_1.read();
            ++var7_5;
lbl25:
            // 3 sources

            if (var4_3 < 48) break;
            ** while (var4_3 <= 57)
        }
lbl27:
        // 3 sources

        if (var4_3 < 0) {
            this.hadEOF = true;
        } else {
            var1_1.unread(var4_3);
        }
        if (var7_5 == 0) {
            throw new NumberFormatException("The next token did not start with a digit");
        }
        return var2_2 * var5_4;
    }

    public short readShort() throws IOException {
        return (short)this.readInt();
    }

    public int readUnsignedShort() throws IOException {
        return this.readInt() & 0xFFFF;
    }

    public String readWord() throws IOException {
        if (this.hadEOF) {
            return null;
        }
        PushbackReader pushbackReader = (PushbackReader)this.in;
        CharQueue charQueue = new CharQueue(126);
        int n = -1;
        boolean bl = false;
        n = this.nextNonWhiteSpaceCharacter();
        while (n != 32 && n != 9 && n != 10 && n != 13 && n >= 0) {
            charQueue.enqueue((char)n);
            n = pushbackReader.read();
        }
        if (n == -1) {
            this.hadEOF = true;
        } else {
            pushbackReader.unread(n);
        }
        if (charQueue.isEmpty()) {
            return null;
        }
        return charQueue.toString();
    }

    public int skipChars(int n) throws IOException {
        Reader reader = this.in;
        int n2 = 0;
        while (n2 < n) {
            n2 += (int)reader.skip(n - n2);
        }
        return n;
    }
}

