/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.apache.hadoop.security.TestLdapGroupsMappingBase;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLdapGroupsMapping
extends TestLdapGroupsMappingBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestLdapGroupsMapping.class);
    private static final byte[] AUTHENTICATE_SUCCESS_MSG = new byte[]{48, 12, 2, 1, 1, 97, 7, 10, 1, 0, 4, 0, 4, 0};
    private final String userDN = "CN=some_user,DC=test,DC=com";
    private static final String TEST_LDAP_URL = "ldap://test";

    @Before
    public void setupMocks() {
        Mockito.when((Object)this.getUserSearchResult().getNameInNamespace()).thenReturn((Object)"CN=some_user,DC=test,DC=com");
    }

    @Test
    public void testGetGroups() throws NamingException {
        Mockito.when(this.getContext().search(Matchers.anyString(), Matchers.anyString(), (Object[])Matchers.any(Object[].class), (SearchControls)Matchers.any(SearchControls.class))).thenReturn(this.getUserNames(), (Object[])new NamingEnumeration[]{this.getGroupNames()});
        this.doTestGetGroups(Arrays.asList(this.getTestGroups()), 2);
    }

    @Test
    public void testGetGroupsWithDifferentBaseDNs() throws Exception {
        Configuration conf = this.getBaseConf(TEST_LDAP_URL);
        String userBaseDN = "ou=Users,dc=xxx,dc=com ";
        String groupBaseDN = " ou=Groups,dc=xxx,dc=com";
        conf.set("hadoop.security.group.mapping.ldap.userbase", userBaseDN);
        conf.set("hadoop.security.group.mapping.ldap.groupbase", groupBaseDN);
        this.doTestGetGroupsWithBaseDN(conf, userBaseDN.trim(), groupBaseDN.trim());
    }

    @Test
    public void testGetGroupsWithDefaultBaseDN() throws Exception {
        Configuration conf = this.getBaseConf(TEST_LDAP_URL);
        String baseDN = " dc=xxx,dc=com ";
        conf.set("hadoop.security.group.mapping.ldap.base", baseDN);
        this.doTestGetGroupsWithBaseDN(conf, baseDN.trim(), baseDN.trim());
    }

    private void doTestGetGroupsWithBaseDN(Configuration conf, String userBaseDN, String groupBaseDN) throws NamingException {
        LdapGroupsMapping groupsMapping = this.getGroupsMapping();
        groupsMapping.setConf(conf);
        String userName = "some_user";
        Mockito.when(this.getContext().search(Matchers.anyString(), Matchers.anyString(), (Object[])Matchers.any(Object[].class), (SearchControls)Matchers.any(SearchControls.class))).thenReturn(this.getUserNames(), (Object[])new NamingEnumeration[]{this.getGroupNames()});
        List groups = groupsMapping.getGroups("some_user");
        Assert.assertEquals(Arrays.asList(this.getTestGroups()), (Object)groups);
        ((DirContext)Mockito.verify((Object)this.getContext(), (VerificationMode)Mockito.times((int)1))).search(userBaseDN, "(&(objectClass=user)(sAMAccountName={0}))", new Object[]{"some_user"}, LdapGroupsMapping.SEARCH_CONTROLS);
        ((DirContext)Mockito.verify((Object)this.getContext(), (VerificationMode)Mockito.times((int)1))).search(groupBaseDN, "(&(objectClass=group)(member={0}))", new Object[]{"CN=some_user,DC=test,DC=com"}, LdapGroupsMapping.SEARCH_CONTROLS);
    }

    @Test
    public void testGetGroupsWithHierarchy() throws NamingException {
        Mockito.when(this.getContext().search(Matchers.anyString(), Matchers.anyString(), (Object[])Matchers.any(Object[].class), (SearchControls)Matchers.any(SearchControls.class))).thenReturn(this.getUserNames(), (Object[])new NamingEnumeration[]{this.getGroupNames()});
        Mockito.when(this.getContext().search(Matchers.anyString(), Matchers.anyString(), (SearchControls)Matchers.any(SearchControls.class))).thenReturn((Object)this.getParentGroupNames());
        this.doTestGetGroupsWithParent(Arrays.asList(this.getTestParentGroups()), 2, 1);
    }

    @Test
    public void testGetGroupsWithConnectionClosed() throws NamingException {
        Mockito.when(this.getContext().search(Matchers.anyString(), Matchers.anyString(), (Object[])Matchers.any(Object[].class), (SearchControls)Matchers.any(SearchControls.class))).thenThrow(new Throwable[]{new CommunicationException("Connection is closed")}).thenReturn(this.getUserNames(), (Object[])new NamingEnumeration[]{this.getGroupNames()});
        this.doTestGetGroups(Arrays.asList(this.getTestGroups()), 3);
    }

    @Test
    public void testGetGroupsWithLdapDown() throws NamingException {
        Mockito.when(this.getContext().search(Matchers.anyString(), Matchers.anyString(), (Object[])Matchers.any(Object[].class), (SearchControls)Matchers.any(SearchControls.class))).thenThrow(new Throwable[]{new CommunicationException("Connection is closed")});
        this.doTestGetGroups(Arrays.asList(new String[0]), 4);
    }

    private void doTestGetGroups(List<String> expectedGroups, int searchTimes) throws NamingException {
        Configuration conf = this.getBaseConf(TEST_LDAP_URL);
        conf.setInt("hadoop.security.group.mapping.ldap.num.attempts", searchTimes);
        LdapGroupsMapping groupsMapping = this.getGroupsMapping();
        groupsMapping.setConf(conf);
        List groups = groupsMapping.getGroups("some_user");
        Assert.assertEquals(expectedGroups, (Object)groups);
        ((DirContext)Mockito.verify((Object)this.getContext(), (VerificationMode)Mockito.times((int)searchTimes))).search(Matchers.anyString(), Matchers.anyString(), (Object[])Matchers.any(Object[].class), (SearchControls)Matchers.any(SearchControls.class));
    }

    private void doTestGetGroupsWithParent(List<String> expectedGroups, int searchTimesGroup, int searchTimesParentGroup) throws NamingException {
        Configuration conf = this.getBaseConf(TEST_LDAP_URL);
        conf.setInt("hadoop.security.group.mapping.ldap.search.group.hierarchy.levels", 1);
        LdapGroupsMapping groupsMapping = this.getGroupsMapping();
        groupsMapping.setConf(conf);
        List groups = groupsMapping.getGroups("some_user");
        Assert.assertEquals(new HashSet<String>(expectedGroups), new HashSet(groups));
        ((DirContext)Mockito.verify((Object)this.getContext(), (VerificationMode)Mockito.times((int)searchTimesGroup))).search(Matchers.anyString(), Matchers.anyString(), (Object[])Matchers.any(Object[].class), (SearchControls)Matchers.any(SearchControls.class));
        ((DirContext)Mockito.verify((Object)this.getContext(), (VerificationMode)Mockito.times((int)searchTimesParentGroup))).search(Matchers.anyString(), Matchers.anyString(), (SearchControls)Matchers.any(SearchControls.class));
    }

    @Test
    public void testExtractPassword() throws IOException {
        File testDir = GenericTestUtils.getTestDir();
        testDir.mkdirs();
        File secretFile = new File(testDir, "secret.txt");
        FileWriter writer = new FileWriter(secretFile);
        writer.write("hadoop");
        ((Writer)writer).close();
        LdapGroupsMapping mapping = new LdapGroupsMapping();
        Assert.assertEquals((Object)"hadoop", (Object)mapping.extractPassword(secretFile.getPath()));
    }

    @Test
    public void testConfGetPassword() throws Exception {
        File testDir = GenericTestUtils.getTestDir();
        Configuration conf = this.getBaseConf();
        Path jksPath = new Path(testDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(testDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        char[] bindpass = new char[]{'b', 'i', 'n', 'd', 'p', 'a', 's', 's'};
        char[] storepass = new char[]{'s', 't', 'o', 'r', 'e', 'p', 'a', 's', 's'};
        Assert.assertNull((Object)provider.getCredentialEntry("hadoop.security.group.mapping.ldap.bind.password"));
        Assert.assertNull((Object)provider.getCredentialEntry("hadoop.security.group.mapping.ldap.ssl.keystore.password"));
        try {
            provider.createCredentialEntry("hadoop.security.group.mapping.ldap.bind.password", bindpass);
            provider.createCredentialEntry("hadoop.security.group.mapping.ldap.ssl.keystore.password", storepass);
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        Assert.assertArrayEquals((char[])bindpass, (char[])provider.getCredentialEntry("hadoop.security.group.mapping.ldap.bind.password").getCredential());
        Assert.assertArrayEquals((char[])storepass, (char[])provider.getCredentialEntry("hadoop.security.group.mapping.ldap.ssl.keystore.password").getCredential());
        LdapGroupsMapping mapping = new LdapGroupsMapping();
        Assert.assertEquals((Object)"bindpass", (Object)mapping.getPassword(conf, "hadoop.security.group.mapping.ldap.bind.password", ""));
        Assert.assertEquals((Object)"storepass", (Object)mapping.getPassword(conf, "hadoop.security.group.mapping.ldap.ssl.keystore.password", ""));
        Assert.assertEquals((Object)"", (Object)mapping.getPassword(conf, "invalid-alias", ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testLdapConnectionTimeout() throws IOException, InterruptedException {
        int connectionTimeoutMs = 3000;
        try (final ServerSocket serverSock = new ServerSocket(0);){
            final CountDownLatch finLatch = new CountDownLatch(1);
            Thread ldapServer = new Thread(new Runnable(){

                @Override
                public void run() {
                    try (Socket ignored = serverSock.accept();){
                        finLatch.await();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            ldapServer.start();
            LdapGroupsMapping mapping = new LdapGroupsMapping();
            String ldapUrl = "ldap://localhost:" + serverSock.getLocalPort();
            Configuration conf = this.getBaseConf(ldapUrl, null);
            conf.setInt("hadoop.security.group.mapping.ldap.connection.timeout.ms", 3000);
            mapping.setConf(conf);
            try {
                mapping.doGetGroups("hadoop", 1);
                Assert.fail((String)"The LDAP query should have timed out!");
            }
            catch (NamingException ne) {
                LOG.debug("Got the exception while LDAP querying: ", (Throwable)ne);
                GenericTestUtils.assertExceptionContains("LDAP response read timed out, timeout used", ne);
                GenericTestUtils.assertExceptionContains("3000", ne);
                Assert.assertFalse((boolean)ne.getMessage().contains("remaining name"));
            }
            finally {
                finLatch.countDown();
            }
            ldapServer.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testLdapReadTimeout() throws IOException, InterruptedException {
        int readTimeoutMs = 4000;
        try (final ServerSocket serverSock = new ServerSocket(0);){
            final CountDownLatch finLatch = new CountDownLatch(1);
            Thread ldapServer = new Thread(new Runnable(){

                @Override
                public void run() {
                    try (Socket clientSock = serverSock.accept();){
                        IOUtils.skipFully((InputStream)clientSock.getInputStream(), (long)1L);
                        clientSock.getOutputStream().write(AUTHENTICATE_SUCCESS_MSG);
                        finLatch.await();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            ldapServer.start();
            LdapGroupsMapping mapping = new LdapGroupsMapping();
            String ldapUrl = "ldap://localhost:" + serverSock.getLocalPort();
            Configuration conf = this.getBaseConf(ldapUrl, null);
            conf.setInt("hadoop.security.group.mapping.ldap.read.timeout.ms", 4000);
            mapping.setConf(conf);
            try {
                mapping.doGetGroups("hadoop", 1);
                Assert.fail((String)"The LDAP query should have timed out!");
            }
            catch (NamingException ne) {
                LOG.debug("Got the exception while LDAP querying: ", (Throwable)ne);
                GenericTestUtils.assertExceptionContains("LDAP response read timed out, timeout used", ne);
                GenericTestUtils.assertExceptionContains("4000", ne);
                GenericTestUtils.assertExceptionContains("remaining name", ne);
            }
            finally {
                finLatch.countDown();
            }
            ldapServer.join();
        }
    }

    @Test(timeout=10000L)
    public void testSetConf() throws Exception {
        Configuration conf = this.getBaseConf(TEST_LDAP_URL);
        Configuration mockConf = (Configuration)Mockito.spy((Object)conf);
        Mockito.when((Object)mockConf.getPassword(Matchers.anyString())).thenThrow(new Throwable[]{new IOException("injected IOException")});
        LdapGroupsMapping groupsMapping = this.getGroupsMapping();
        groupsMapping.setConf(mockConf);
    }
}

