/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.wal.WAL;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public class ChainWALEntryFilter
implements WALEntryFilter {
    private final WALEntryFilter[] filters;

    public ChainWALEntryFilter(WALEntryFilter ... filters) {
        this.filters = filters;
    }

    public ChainWALEntryFilter(List<WALEntryFilter> filters) {
        ArrayList<WALEntryFilter> rawFilters = new ArrayList<WALEntryFilter>(filters.size());
        for (WALEntryFilter filter : filters) {
            if (filter instanceof ChainWALEntryFilter) {
                Collections.addAll(rawFilters, ((ChainWALEntryFilter)filter).filters);
                continue;
            }
            rawFilters.add(filter);
        }
        this.filters = rawFilters.toArray(new WALEntryFilter[rawFilters.size()]);
    }

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        for (WALEntryFilter filter : this.filters) {
            if (entry == null) {
                return null;
            }
            entry = filter.filter(entry);
        }
        return entry;
    }
}

