/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestApplyingStoragePolicy {
    private static final short REPL = 1;
    private static final int SIZE = 128;
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem fs;

    @Before
    public void clusterSetUp() throws IOException {
        conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
    }

    @After
    public void clusterShutdown() throws IOException {
        if (fs != null) {
            fs.close();
            fs = null;
        }
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    public void testStoragePolicyByDefault() throws Exception {
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        Path wow = new Path(bar, "wow");
        Path fooz = new Path(bar, "/fooz");
        DFSTestUtil.createFile((FileSystem)fs, wow, 128L, (short)1, 0L);
        BlockStoragePolicySuite suite = BlockStoragePolicySuite.createDefaultSuite();
        BlockStoragePolicy hot = suite.getPolicy("HOT");
        Assert.assertEquals((Object)fs.getStoragePolicy(foo), (Object)hot);
        Assert.assertEquals((Object)fs.getStoragePolicy(bar), (Object)hot);
        Assert.assertEquals((Object)fs.getStoragePolicy(wow), (Object)hot);
        try {
            fs.getStoragePolicy(fooz);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
    }

    @Test
    public void testSetAndUnsetStoragePolicy() throws Exception {
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        Path wow = new Path(bar, "wow");
        Path fooz = new Path(bar, "/fooz");
        DFSTestUtil.createFile((FileSystem)fs, wow, 128L, (short)1, 0L);
        BlockStoragePolicySuite suite = BlockStoragePolicySuite.createDefaultSuite();
        BlockStoragePolicy warm = suite.getPolicy("WARM");
        BlockStoragePolicy cold = suite.getPolicy("COLD");
        BlockStoragePolicy hot = suite.getPolicy("HOT");
        fs.setStoragePolicy(foo, warm.getName());
        fs.setStoragePolicy(bar, cold.getName());
        fs.setStoragePolicy(wow, hot.getName());
        try {
            fs.setStoragePolicy(fooz, warm.getName());
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
        Assert.assertEquals((Object)fs.getStoragePolicy(foo), (Object)warm);
        Assert.assertEquals((Object)fs.getStoragePolicy(bar), (Object)cold);
        Assert.assertEquals((Object)fs.getStoragePolicy(wow), (Object)hot);
        try {
            fs.getStoragePolicy(fooz);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
        fs.unsetStoragePolicy(foo);
        fs.unsetStoragePolicy(bar);
        fs.unsetStoragePolicy(wow);
        try {
            fs.unsetStoragePolicy(fooz);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
        Assert.assertEquals((Object)fs.getStoragePolicy(foo), (Object)hot);
        Assert.assertEquals((Object)fs.getStoragePolicy(bar), (Object)hot);
        Assert.assertEquals((Object)fs.getStoragePolicy(wow), (Object)hot);
        try {
            fs.getStoragePolicy(fooz);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
    }

    @Test
    public void testNestedStoragePolicy() throws Exception {
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        Path wow = new Path(bar, "wow");
        Path fooz = new Path("/foos");
        DFSTestUtil.createFile((FileSystem)fs, wow, 128L, (short)1, 0L);
        BlockStoragePolicySuite suite = BlockStoragePolicySuite.createDefaultSuite();
        BlockStoragePolicy warm = suite.getPolicy("WARM");
        BlockStoragePolicy cold = suite.getPolicy("COLD");
        BlockStoragePolicy hot = suite.getPolicy("HOT");
        fs.setStoragePolicy(foo, warm.getName());
        fs.setStoragePolicy(bar, cold.getName());
        fs.setStoragePolicy(wow, hot.getName());
        try {
            fs.setStoragePolicy(fooz, warm.getName());
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
        Assert.assertEquals((Object)fs.getStoragePolicy(foo), (Object)warm);
        Assert.assertEquals((Object)fs.getStoragePolicy(bar), (Object)cold);
        Assert.assertEquals((Object)fs.getStoragePolicy(wow), (Object)hot);
        try {
            fs.getStoragePolicy(fooz);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
        fs.unsetStoragePolicy(wow);
        Assert.assertEquals((Object)fs.getStoragePolicy(wow), (Object)cold);
        fs.unsetStoragePolicy(bar);
        Assert.assertEquals((Object)fs.getStoragePolicy(bar), (Object)warm);
        fs.unsetStoragePolicy(foo);
        Assert.assertEquals((Object)fs.getStoragePolicy(foo), (Object)hot);
        try {
            fs.unsetStoragePolicy(fooz);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
        Assert.assertEquals((Object)fs.getStoragePolicy(foo), (Object)hot);
        Assert.assertEquals((Object)fs.getStoragePolicy(bar), (Object)hot);
        Assert.assertEquals((Object)fs.getStoragePolicy(wow), (Object)hot);
        try {
            fs.getStoragePolicy(fooz);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
    }

    @Test
    public void testSetAndGetStoragePolicy() throws IOException {
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        Path fooz = new Path("/fooz");
        DFSTestUtil.createFile((FileSystem)fs, bar, 128L, (short)1, 0L);
        BlockStoragePolicySuite suite = BlockStoragePolicySuite.createDefaultSuite();
        BlockStoragePolicy warm = suite.getPolicy("WARM");
        BlockStoragePolicy cold = suite.getPolicy("COLD");
        BlockStoragePolicy hot = suite.getPolicy("HOT");
        Assert.assertEquals((Object)fs.getStoragePolicy(foo), (Object)hot);
        Assert.assertEquals((Object)fs.getStoragePolicy(bar), (Object)hot);
        try {
            fs.getStoragePolicy(fooz);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
        fs.setStoragePolicy(foo, warm.getName());
        fs.setStoragePolicy(bar, cold.getName());
        try {
            fs.setStoragePolicy(fooz, warm.getName());
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
        Assert.assertEquals((Object)fs.getStoragePolicy(foo), (Object)warm);
        Assert.assertEquals((Object)fs.getStoragePolicy(bar), (Object)cold);
        try {
            fs.getStoragePolicy(fooz);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
    }
}

