/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import org.apache.nifi.bootstrap.command.io.ResponseStreamHandler;
import org.slf4j.Logger;

public class LoggerResponseStreamHandler
implements ResponseStreamHandler {
    private final Logger logger;

    public LoggerResponseStreamHandler(Logger logger) {
        this.logger = Objects.requireNonNull(logger);
    }

    @Override
    public void onResponseStream(InputStream responseStream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseStream));){
            reader.lines().forEach(arg_0 -> ((Logger)this.logger).info(arg_0));
        }
        catch (IOException e) {
            this.logger.warn("Read response stream failed", (Throwable)e);
        }
    }
}

