/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.nifi.repository.encryption.metadata.serialization;

import java.io.Serializable;

/**
 * Record Metadata object with properties used for compatibility with serialized streams or bytes
 */
class SerializableRecordMetadata implements Serializable  {
    private static final long serialVersionUID = 1;

    private static final int STREAM_LENGTH = -1;

    public String keyId;
    public byte[] ivBytes;
    public String algorithm;
    public String version;
    public int cipherByteLength = STREAM_LENGTH;
}
