/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.enterprise.context.RequestScoped;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.UserAgent;
import org.apache.myfaces.tobago.internal.util.CookieUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@RequestScoped
public class TobagoContext
implements Serializable {
    public static final String BEAN_NAME = "tobagoContext";
    public static final String FOCUS_ID_KEY = "tobago.focusId";
    public static final String ENCTYPE_KEY = "tobago.enctype";
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Deprecated
    public ResourceBundle getResourceBundle() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale locale = viewRoot != null ? viewRoot.getLocale() : facesContext.getApplication().getDefaultLocale();
        return ResourceBundle.getBundle("tobagoResourceBundle", locale);
    }

    @Deprecated
    public ResourceBundle getMessageBundle() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale locale = viewRoot != null ? viewRoot.getLocale() : facesContext.getApplication().getDefaultLocale();
        return ResourceBundle.getBundle("org.apache.myfaces.tobago.context.TobagoMessage", locale);
    }

    public TobagoConfig getTobagoConfig() {
        return TobagoConfig.getInstance(FacesContext.getCurrentInstance());
    }

    public Theme getTheme() {
        String themeName;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Theme theme = (Theme)facesContext.getAttributes().get("tobago.theme");
        if (theme != null) {
            return theme;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        Object request = externalContext.getRequest();
        Object session = externalContext.getSession(false);
        if (session instanceof HttpSession && this.getTobagoConfig().isThemeSession()) {
            themeName = (String)((HttpSession)session).getAttribute("tobago.theme");
            theme = this.getTobagoConfig().getThemeIfExists(themeName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("from session theme='{}'", (Object)theme.getName());
            }
        }
        if (theme == null && request instanceof HttpServletRequest && this.getTobagoConfig().isThemeCookie()) {
            themeName = CookieUtils.getThemeNameFromCookie((HttpServletRequest)request);
            theme = this.getTobagoConfig().getTheme(themeName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("from cookie theme='{}'", (Object)theme.getName());
            }
        }
        if (theme == null) {
            theme = this.getTobagoConfig().getDefaultTheme();
        }
        facesContext.getAttributes().put("tobago.theme", theme);
        return theme;
    }

    public void setTheme(Theme theme) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.getAttributes().put("tobago.theme", theme);
        ExternalContext externalContext = facesContext.getExternalContext();
        Object request = externalContext.getRequest();
        Object response = externalContext.getResponse();
        Object session = externalContext.getSession(false);
        if (response instanceof HttpServletResponse && request instanceof HttpServletRequest && this.getTobagoConfig().isThemeCookie()) {
            CookieUtils.setThemeNameToCookie((HttpServletRequest)request, (HttpServletResponse)response, theme.getName());
        }
        if (session instanceof HttpSession && this.getTobagoConfig().isThemeSession()) {
            ((HttpSession)session).setAttribute("tobago.theme", (Object)theme.getName());
        }
    }

    public UserAgent getUserAgent() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        String requestUserAgent = (String)externalContext.getRequestHeaderMap().get("User-Agent");
        UserAgent userAgent = UserAgent.getInstance(requestUserAgent);
        if (LOG.isDebugEnabled()) {
            LOG.debug("userAgent='" + userAgent + "' from header 'User-Agent: " + requestUserAgent + "'");
        }
        return userAgent;
    }

    public void setUserAgent(UserAgent userAgent) {
        LOG.warn("Setting user agent ignored! param={}", (Object)userAgent);
    }

    public String getFocusId() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (String)facesContext.getAttributes().get(FOCUS_ID_KEY);
    }

    public void setFocusId(String focusId) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.getAttributes().put(FOCUS_ID_KEY, focusId);
    }

    public String getEnctype() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (String)facesContext.getAttributes().get(ENCTYPE_KEY);
    }

    public void setEnctype(String enctype) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.getAttributes().put(ENCTYPE_KEY, enctype);
    }

    public Boolean getFocusOnError() {
        Boolean focusOnError = (Boolean)FacesContext.getCurrentInstance().getAttributes().get((Object)Attributes.focusOnError);
        if (focusOnError != null) {
            return focusOnError;
        }
        return true;
    }

    public void setFocusOnError(Boolean focusOnError) {
        FacesContext.getCurrentInstance().getAttributes().put(Attributes.focusOnError, focusOnError);
    }

    public Integer getWaitOverlayDelayFull() {
        Integer waitOverlayDelayFull = (Integer)FacesContext.getCurrentInstance().getAttributes().get((Object)Attributes.waitOverlayDelayFull);
        if (waitOverlayDelayFull != null) {
            return waitOverlayDelayFull;
        }
        return 1000;
    }

    public void setWaitOverlayDelayFull(Integer waitOverlayDelayFull) {
        FacesContext.getCurrentInstance().getAttributes().put(Attributes.waitOverlayDelayFull, waitOverlayDelayFull);
    }

    public Integer getWaitOverlayDelayAjax() {
        Integer waitOverlayDelayAjax = (Integer)FacesContext.getCurrentInstance().getAttributes().get((Object)Attributes.waitOverlayDelayAjax);
        if (waitOverlayDelayAjax != null) {
            return waitOverlayDelayAjax;
        }
        return 1000;
    }

    public void setWaitOverlayDelayAjax(Integer waitOverlayDelayAjax) {
        FacesContext.getCurrentInstance().getAttributes().put(Attributes.waitOverlayDelayAjax, waitOverlayDelayAjax);
    }

    public static TobagoContext getInstance(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        if (requestMap.containsKey(BEAN_NAME)) {
            return (TobagoContext)requestMap.get(BEAN_NAME);
        }
        TobagoContext tobagoContext = new TobagoContext();
        requestMap.put(BEAN_NAME, tobagoContext);
        return tobagoContext;
    }
}

