/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.startup;

import org.apache.myfaces.extensions.validator.ExtValInformation;
import org.apache.myfaces.extensions.validator.core.CustomInformation;
import org.apache.myfaces.extensions.validator.core.DefaultExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.PhaseIdRecordingPhaseListener;
import org.apache.myfaces.extensions.validator.core.interceptor.FacesMessagePropertyValidationInterceptor;
import org.apache.myfaces.extensions.validator.core.interceptor.HtmlCoreComponentsValidationExceptionInterceptor;
import org.apache.myfaces.extensions.validator.core.interceptor.ValidationInterceptor;
import org.apache.myfaces.extensions.validator.core.interceptor.ViolationExceptionInterceptor;
import org.apache.myfaces.extensions.validator.core.interceptor.ViolationSeverityValidationExceptionInterceptor;
import org.apache.myfaces.extensions.validator.core.metadata.transformer.mapper.BeanValidationStrategyToMetaDataTransformerNameMapper;
import org.apache.myfaces.extensions.validator.core.metadata.transformer.mapper.CustomConfiguredValidationStrategyToMetaDataTransformerNameMapper;
import org.apache.myfaces.extensions.validator.core.metadata.transformer.mapper.CustomConventionValidationStrategyToMetaDataTransformerNameMapper;
import org.apache.myfaces.extensions.validator.core.metadata.transformer.mapper.DefaultValidationStrategyToMetaDataTransformerNameMapper;
import org.apache.myfaces.extensions.validator.core.metadata.transformer.mapper.SimpleValidationStrategyToMetaDataTransformerNameMapper;
import org.apache.myfaces.extensions.validator.core.startup.AbstractStartupListener;
import org.apache.myfaces.extensions.validator.core.validation.message.resolver.mapper.CustomConfiguredValidationStrategyToMsgResolverNameMapper;
import org.apache.myfaces.extensions.validator.core.validation.message.resolver.mapper.CustomConventionValidationStrategyToMsgResolverNameMapper;
import org.apache.myfaces.extensions.validator.core.validation.message.resolver.mapper.DefaultModuleValidationStrategyToMsgResolverNameMapper;
import org.apache.myfaces.extensions.validator.core.validation.message.resolver.mapper.DefaultValidationStrategyToMsgResolverNameMapper;
import org.apache.myfaces.extensions.validator.core.validation.message.resolver.mapper.SimpleValidationStrategyToMsgResolverNameMapper;
import org.apache.myfaces.extensions.validator.core.validation.parameter.DefaultViolationSeverityInterpreter;
import org.apache.myfaces.extensions.validator.core.validation.parameter.DisableClientSideValidation;
import org.apache.myfaces.extensions.validator.core.validation.parameter.ViolationSeverity;
import org.apache.myfaces.extensions.validator.core.validation.strategy.mapper.AnnotationToValidationStrategyBeanNameMapper;
import org.apache.myfaces.extensions.validator.core.validation.strategy.mapper.CustomConfiguredAnnotationToValidationStrategyNameMapper;
import org.apache.myfaces.extensions.validator.core.validation.strategy.mapper.CustomConventionAnnotationToValidationStrategyNameMapper;
import org.apache.myfaces.extensions.validator.core.validation.strategy.mapper.DefaultAnnotationToValidationStrategyNameMapper;
import org.apache.myfaces.extensions.validator.core.validation.strategy.mapper.SimpleAnnotationToValidationStrategyNameMapper;
import org.apache.myfaces.extensions.validator.internal.Priority;
import org.apache.myfaces.extensions.validator.internal.ToDo;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.JsfUtils;

@UsageInformation(value={UsageCategory.INTERNAL})
public class ExtValStartupListener
extends AbstractStartupListener {
    private static final long serialVersionUID = -2504826421086572012L;

    protected void initModuleConfig() {
        ExtValCoreConfiguration.use(new DefaultExtValCoreConfiguration(), false);
    }

    protected void init() {
        if (ExtValInformation.VERSION != null && !ExtValInformation.VERSION.startsWith("null")) {
            this.logger.info("starting up MyFaces Extensions Validator v" + ExtValInformation.VERSION);
        } else {
            this.logger.info("starting up MyFaces Extensions Validator");
        }
        ExtValContext.getContext().registerRendererInterceptor(new ValidationInterceptor());
        this.initNameMappers();
        this.initValidationExceptionInterceptors();
        this.initViolationSeverityInterpreter();
        this.initPropertyValidationInterceptors();
        this.initPhaseListeners();
        this.initViolationSeverityKey();
        this.initDisableClientSideValidationKey();
        this.executeCustomStartupListener();
    }

    private void initNameMappers() {
        if (ExtValCoreConfiguration.get().deactivateDefaultNameMappers()) {
            return;
        }
        ExtValUtils.registerMetaDataToValidationStrategyNameMapper(new CustomConfiguredAnnotationToValidationStrategyNameMapper());
        ExtValUtils.registerMetaDataToValidationStrategyNameMapper(new CustomConventionAnnotationToValidationStrategyNameMapper());
        ExtValUtils.registerMetaDataToValidationStrategyNameMapper(new DefaultAnnotationToValidationStrategyNameMapper());
        ExtValUtils.registerMetaDataToValidationStrategyNameMapper(new SimpleAnnotationToValidationStrategyNameMapper());
        ExtValUtils.registerMetaDataToValidationStrategyNameMapper(new AnnotationToValidationStrategyBeanNameMapper(new CustomConfiguredAnnotationToValidationStrategyNameMapper()));
        ExtValUtils.registerMetaDataToValidationStrategyNameMapper(new AnnotationToValidationStrategyBeanNameMapper(new CustomConventionAnnotationToValidationStrategyNameMapper()));
        ExtValUtils.registerMetaDataToValidationStrategyNameMapper(new AnnotationToValidationStrategyBeanNameMapper(new DefaultAnnotationToValidationStrategyNameMapper()));
        ExtValUtils.registerMetaDataToValidationStrategyNameMapper(new AnnotationToValidationStrategyBeanNameMapper(new SimpleAnnotationToValidationStrategyNameMapper()));
        ExtValUtils.registerValidationStrategyToMessageResolverNameMapper(new CustomConfiguredValidationStrategyToMsgResolverNameMapper());
        ExtValUtils.registerValidationStrategyToMessageResolverNameMapper(new CustomConventionValidationStrategyToMsgResolverNameMapper());
        ExtValUtils.registerValidationStrategyToMessageResolverNameMapper(new DefaultValidationStrategyToMsgResolverNameMapper());
        ExtValUtils.registerValidationStrategyToMessageResolverNameMapper(new DefaultModuleValidationStrategyToMsgResolverNameMapper());
        ExtValUtils.registerValidationStrategyToMessageResolverNameMapper(new SimpleValidationStrategyToMsgResolverNameMapper());
        ExtValUtils.registerValidationStrategyToMetaDataTransformerNameMapper(new CustomConfiguredValidationStrategyToMetaDataTransformerNameMapper());
        ExtValUtils.registerValidationStrategyToMetaDataTransformerNameMapper(new CustomConventionValidationStrategyToMetaDataTransformerNameMapper());
        ExtValUtils.registerValidationStrategyToMetaDataTransformerNameMapper(new DefaultValidationStrategyToMetaDataTransformerNameMapper());
        ExtValUtils.registerValidationStrategyToMetaDataTransformerNameMapper(new SimpleValidationStrategyToMetaDataTransformerNameMapper());
        ExtValUtils.registerValidationStrategyToMetaDataTransformerNameMapper(new BeanValidationStrategyToMetaDataTransformerNameMapper());
    }

    private void executeCustomStartupListener() {
        String customStartupListenerName = ExtValContext.getContext().getInformationProviderBean().get(CustomInformation.STARTUP_LISTENER);
        AbstractStartupListener customStartupListener = (AbstractStartupListener)ClassUtils.tryToInstantiateClassForName(customStartupListenerName);
        if (customStartupListener != null) {
            this.logger.info("start init of " + customStartupListener.getClass().getName());
            customStartupListener.init();
            this.logger.info("init of " + customStartupListener.getClass().getName() + " finished");
        }
    }

    private void initValidationExceptionInterceptors() {
        ExtValContext.getContext().addValidationExceptionInterceptor(new HtmlCoreComponentsValidationExceptionInterceptor());
        ExtValContext.getContext().addValidationExceptionInterceptor(new ViolationSeverityValidationExceptionInterceptor());
        ExtValContext.getContext().addValidationExceptionInterceptor(new ViolationExceptionInterceptor());
    }

    private void initViolationSeverityInterpreter() {
        ExtValContext.getContext().setViolationSeverityInterpreter(new DefaultViolationSeverityInterpreter(), false);
    }

    private void initPropertyValidationInterceptors() {
        ExtValContext.getContext().addPropertyValidationInterceptor(new FacesMessagePropertyValidationInterceptor());
    }

    private void initPhaseListeners() {
        JsfUtils.registerPhaseListener(new PhaseIdRecordingPhaseListener());
    }

    @Deprecated
    @ToDo(value=Priority.MEDIUM, description="DefaultValidationParameterFactory#tryToFindGlobalParameter still usesthe global parameter")
    private void initViolationSeverityKey() {
        ExtValContext.getContext().addGlobalProperty(ViolationSeverity.class.getName(), ExtValCoreConfiguration.get().violationSeverity(), false);
    }

    @Deprecated
    private void initDisableClientSideValidationKey() {
        ExtValContext.getContext().addGlobalProperty(DisableClientSideValidation.class.getName(), ExtValCoreConfiguration.get().disableClientSideValidationValidationParameter(), false);
    }
}

