/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.test;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.jboss.resteasy.client.ProxyFactory;

public class TestPortProvider {
    private static final int DEFAULT_PORT = 8081;
    private static final String ENV_VAR_NAME = "RESTEASY_PORT";
    private static final String PROPERTY_NAME = "org.jboss.resteasy.port";
    private static final String DEFAULT_HOST = "localhost";
    private static final String ENV_VAR_HOSTNAME = "RESTEASY_HOST";
    private static final String PROPERTY_HOSTNAME = "org.jboss.resteasy.host";

    public static ClientRequest createClientRequest(String path) {
        return new ClientRequest(TestPortProvider.generateURL(path));
    }

    public static ClientRequest createClientRequest(ClientRequestFactory factory, String path) {
        return factory.createRequest(TestPortProvider.generateURL(path));
    }

    public static <T> T createProxy(Class<T> clazz) {
        return TestPortProvider.createProxy(clazz, "");
    }

    public static <T> T createProxy(Class<T> clazz, String path) {
        return ProxyFactory.create(clazz, TestPortProvider.generateURL(path));
    }

    public static URI createURI(String path) {
        return URI.create(TestPortProvider.generateURL(path));
    }

    public static URL createURL(String path) throws MalformedURLException {
        return new URL(TestPortProvider.generateURL(path));
    }

    public static String generateBaseUrl() {
        return TestPortProvider.generateURL("");
    }

    public static String generateURL(String path) {
        return String.format("http://%s:%d%s", TestPortProvider.getHost(), TestPortProvider.getPort(), path);
    }

    public static int getPort() {
        int port = -1;
        String property = System.getenv(ENV_VAR_NAME);
        if (property != null) {
            try {
                port = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (port == -1 && (property = System.getProperty(PROPERTY_NAME)) != null) {
            try {
                port = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (port == -1) {
            port = 8081;
        }
        return port;
    }

    public static String getHost() {
        String host = null;
        String property = System.getenv(ENV_VAR_HOSTNAME);
        if (property != null) {
            host = property;
        }
        if (host == null && (property = System.getProperty(PROPERTY_HOSTNAME)) != null) {
            host = property;
        }
        if (host == null) {
            host = DEFAULT_HOST;
        }
        return host;
    }
}

