/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLProfiler
extends AbstractParser {
    public static Property ROOT_ENTITY = Property.internalText((String)"xmlprofiler:root_entity");
    public static Property ENTITY_URIS = Property.internalTextBag((String)"xmlprofiler:entity_uris");
    public static Property ENTITY_LOCAL_NAMES = Property.internalTextBag((String)"xmlprofiler:entity_local_names");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"xml"), MediaType.application((String)"rdf+xml"), MediaType.application((String)"vnd.adobe.xdp+xml"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XMLReaderUtils.parseSAX((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler((ContentHandler)new XMLProfileHandler(metadata)), (ParseContext)context);
    }

    private static class XMLProfileHandler
    extends DefaultHandler {
        private final Metadata metadata;
        int starts = 0;
        Map<String, Set> entities = new TreeMap<String, Set>();

        public XMLProfileHandler(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            TreeSet<String> localNames;
            if (this.starts == 0) {
                this.metadata.set(ROOT_ENTITY, qName);
            }
            if ((localNames = this.entities.get(uri)) == null) {
                localNames = new TreeSet<String>();
                this.entities.put(uri, localNames);
            }
            localNames.add(localName);
            ++this.starts;
        }

        @Override
        public void endDocument() throws SAXException {
            String[] uris = new String[this.entities.size()];
            String[] localNames = new String[this.entities.size()];
            int i = 0;
            for (Map.Entry<String, Set> e : this.entities.entrySet()) {
                uris[i] = e.getKey();
                localNames[i] = XMLProfileHandler.joinWith(" ", e.getValue());
                ++i;
            }
            this.metadata.set(ENTITY_URIS, uris);
            this.metadata.set(ENTITY_LOCAL_NAMES, localNames);
        }

        static String joinWith(String delimiter, Collection<String> strings) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (String s : strings) {
                if (i > 0) {
                    sb.append(delimiter);
                }
                sb.append(s);
                ++i;
            }
            return sb.toString();
        }
    }
}

