/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.CellIDArray;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGUIDArray;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid;

public class ObjectGroupObjectDataBLOBReference
extends StreamObject {
    public ExGUIDArray objectExtendedGUIDArray = new ExGUIDArray();
    public CellIDArray cellIDArray = new CellIDArray();
    public ExGuid blobExtendedGUID = new ExGuid();

    public ObjectGroupObjectDataBLOBReference() {
        super(StreamObjectTypeHeaderStart.ObjectGroupObjectDataBLOBReference);
    }

    @Override
    protected void deserializeItemsFromByteArray(byte[] byteArray, AtomicInteger currentIndex, int lengthOfItems) throws TikaException, IOException {
        AtomicInteger index = new AtomicInteger(currentIndex.get());
        this.objectExtendedGUIDArray = BasicObject.parse(byteArray, index, ExGUIDArray.class);
        this.cellIDArray = BasicObject.parse(byteArray, index, CellIDArray.class);
        this.blobExtendedGUID = BasicObject.parse(byteArray, index, ExGuid.class);
        if (index.get() - currentIndex.get() != lengthOfItems) {
            throw new StreamObjectParseErrorException(currentIndex.get(), "ObjectGroupObjectDataBLOBReference", "Stream object over-parse error", null);
        }
        currentIndex.set(index.get());
    }

    @Override
    protected int serializeItemsToByteList(List<Byte> byteList) throws IOException {
        int itemsIndex = byteList.size();
        byteList.addAll(this.objectExtendedGUIDArray.serializeToByteList());
        byteList.addAll(this.cellIDArray.serializeToByteList());
        byteList.addAll(this.blobExtendedGUID.serializeToByteList());
        return byteList.size() - itemsIndex;
    }
}

