/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBPort;
import com.mongodb.MongoClientException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoOptions;
import com.mongodb.MongoTimeoutException;
import com.mongodb.MongoWaitQueueFullException;
import com.mongodb.ServerAddress;
import com.mongodb.util.SimplePool;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DBPortPool
extends SimplePool<DBPort> {
    final MongoOptions _options;
    private final Semaphore _waitingSem;
    final ServerAddress _addr;

    public String getHost() {
        return this._addr.getHost();
    }

    public int getPort() {
        return this._addr.getPort();
    }

    DBPortPool(ServerAddress addr, MongoOptions options) {
        super("DBPortPool-" + addr.toString() + ", options = " + options.toString(), options.connectionsPerHost);
        this._options = options;
        this._addr = addr;
        this._waitingSem = new Semaphore(this._options.connectionsPerHost * this._options.threadsAllowedToBlockForConnectionMultiplier);
    }

    @Override
    public DBPort get() {
        DBPort port = null;
        if (!this._waitingSem.tryAcquire()) {
            throw new SemaphoresOut(this._options.connectionsPerHost * this._options.threadsAllowedToBlockForConnectionMultiplier);
        }
        try {
            port = (DBPort)this.get(this._options.maxWaitTime);
        }
        catch (InterruptedException e) {
            throw new MongoInterruptedException(e);
        }
        finally {
            this._waitingSem.release();
        }
        if (port == null) {
            throw new ConnectionWaitTimeOut(this._options.maxWaitTime);
        }
        return port;
    }

    @Override
    public void cleanup(DBPort p) {
        p.close();
    }

    @Override
    protected DBPort createNew() {
        return new DBPort(this._addr);
    }

    public ServerAddress getServerAddress() {
        return this._addr;
    }

    @Deprecated
    public static class ConnectionWaitTimeOut
    extends MongoTimeoutException {
        private static final long serialVersionUID = -4415279469780082174L;

        ConnectionWaitTimeOut(int timeout) {
            super("Connection wait timeout after " + timeout + " ms");
        }
    }

    @Deprecated
    public static class SemaphoresOut
    extends MongoWaitQueueFullException {
        private static final long serialVersionUID = -4415279469780082174L;
        private static final String message = "Concurrent requests for database connection have exceeded limit";

        SemaphoresOut() {
            super(message);
        }

        SemaphoresOut(int numPermits) {
            super("Concurrent requests for database connection have exceeded limit of " + numPermits);
        }
    }

    @Deprecated
    public static class NoMoreConnection
    extends MongoClientException {
        private static final long serialVersionUID = -4415279469780082174L;

        public NoMoreConnection(String msg) {
            super(msg);
        }
    }
}

