/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.SampleModelFactory;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.storage.AbstractResource;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.PerformanceLevel;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class AbstractGridResource
extends AbstractResource
implements GridCoverageResource {
    protected AbstractGridResource(StoreListeners storeListeners) {
        super(storeListeners);
    }

    @Override
    public Optional<Envelope> getEnvelope() throws DataStoreException {
        GridGeometry gridGeometry = this.getGridGeometry();
        if (gridGeometry != null && gridGeometry.isDefined(2)) {
            return Optional.of(gridGeometry.getEnvelope());
        }
        return Optional.empty();
    }

    @Override
    protected void createMetadata(MetadataBuilder metadataBuilder) throws DataStoreException {
        super.createMetadata(metadataBuilder);
        metadataBuilder.addSpatialRepresentation(null, this.getGridGeometry(), false);
        for (SampleDimension sampleDimension : this.getSampleDimensions()) {
            metadataBuilder.addNewBand(sampleDimension);
        }
    }

    protected final RangeArgument validateRangeArgument(int n, int[] nArray) {
        long[] lArray;
        ArgumentChecks.ensureStrictlyPositive("numSampleDimensions", n);
        if (nArray == null || nArray.length == 0) {
            lArray = new long[n];
            for (int i = 1; i < n; ++i) {
                lArray[i] = (long)i << 32 | (long)i;
            }
        } else {
            int n2;
            int n3;
            lArray = new long[nArray.length];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                if (n2 < 0 || n2 >= n) {
                    throw new IllegalArgumentException(Resources.forLocale(this.getLocale()).getString((short)52, n - 1, n2));
                }
                lArray[n3] = (long)n2 << 32 | (long)n3;
            }
            Arrays.sort(lArray);
            n3 = -1;
            for (n2 = 0; n2 < lArray.length; ++n2) {
                int n4 = (int)(lArray[n2] >>> 32);
                if (n4 == n3) {
                    throw new IllegalArgumentException(Resources.forLocale(this.getLocale()).getString((short)53, n4));
                }
                n3 = n4;
            }
        }
        return new RangeArgument(lArray, lArray.length == n);
    }

    protected static Exception getReferencingCause(RuntimeException runtimeException) {
        Throwable throwable = runtimeException.getCause();
        if (throwable instanceof FactoryException || throwable instanceof TransformException) {
            return (Exception)throwable;
        }
        return null;
    }

    protected final void logReadOperation(Object object, GridGeometry gridGeometry, long l) {
        long l2;
        Level level;
        Logger logger = this.getLogger();
        if (logger.isLoggable(level = PerformanceLevel.forDuration(l2 = System.nanoTime() - l, TimeUnit.NANOSECONDS))) {
            Locale locale = this.getLocale();
            Object[] objectArray = new Object[6];
            objectArray[0] = IOUtilities.filename(object != null ? object : this.getSourceName());
            objectArray[5] = (double)l2 / 1.0E9;
            JDK9.ifPresentOrElse(gridGeometry.getGeographicExtent(), geographicBoundingBox -> {
                AngleFormat angleFormat = new AngleFormat(locale);
                double d = geographicBoundingBox.getSouthBoundLatitude();
                double d2 = geographicBoundingBox.getNorthBoundLatitude();
                angleFormat.setPrecision(d2 - d, true);
                angleFormat.setRoundingMode(RoundingMode.FLOOR);
                objectArray[1] = angleFormat.format(new Latitude(d));
                angleFormat.setRoundingMode(RoundingMode.CEILING);
                objectArray[2] = angleFormat.format(new Latitude(d2));
                d = geographicBoundingBox.getWestBoundLongitude();
                d2 = geographicBoundingBox.getEastBoundLongitude();
                angleFormat.setPrecision(d2 - d, true);
                angleFormat.setRoundingMode(RoundingMode.FLOOR);
                objectArray[3] = angleFormat.format(new Longitude(d));
                angleFormat.setRoundingMode(RoundingMode.CEILING);
                objectArray[4] = angleFormat.format(new Longitude(d2));
            }, () -> {
                block3: {
                    block2: {
                        if (!gridGeometry.isDefined(2)) break block2;
                        Envelope envelope = gridGeometry.getEnvelope();
                        int n = Math.min(envelope.getDimension(), 2);
                        int n2 = 1;
                        for (int i = 0; i < n; ++i) {
                            objectArray[n2++] = envelope.getMinimum(i);
                            objectArray[n2++] = envelope.getMaximum(i);
                        }
                        break block3;
                    }
                    if (!gridGeometry.isDefined(4)) break block3;
                    GridExtent gridExtent = gridGeometry.getExtent();
                    int n = Math.min(gridExtent.getDimension(), 2);
                    int n3 = 1;
                    for (int i = 0; i < n; ++i) {
                        objectArray[n3++] = gridExtent.getLow(i);
                        objectArray[n3++] = gridExtent.getHigh(i);
                    }
                }
            });
            LogRecord logRecord = Resources.forLocale(locale).getLogRecord(level, (short)59, objectArray);
            logRecord.setSourceClassName(GridCoverageResource.class.getName());
            logRecord.setSourceMethodName("read");
            logRecord.setLoggerName(logger.getName());
            logger.log(logRecord);
        }
    }

    protected static final class RangeArgument {
        private final long[] packed;
        public final boolean hasAllBands;
        private int first;
        private int last;
        private int interval;
        private SampleDimension.Builder builder;

        private RangeArgument(long[] lArray, boolean bl) {
            this.packed = lArray;
            this.hasAllBands = bl;
            this.interval = 1;
        }

        public boolean isIdentity() {
            if (!this.hasAllBands || this.interval != 1) {
                return false;
            }
            for (int i = 0; i < this.packed.length; ++i) {
                if (this.packed[i] == ((long)i << 32 | (long)i)) continue;
                return false;
            }
            return true;
        }

        public int getNumBands() {
            return this.packed.length;
        }

        public int[] getSelectedBands() {
            int[] nArray = new int[this.getNumBands()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[this.getTargetIndex((int)i)] = this.getSourceIndex(i);
            }
            return nArray;
        }

        public int getFirstSpecified() {
            for (long l : this.packed) {
                if ((int)l != 0) continue;
                return (int)(l >>> 32);
            }
            throw new IllegalStateException();
        }

        public int getSourceIndex(int n) {
            return (int)(this.packed[n] >>> 32);
        }

        public int getTargetIndex(int n) {
            return (int)this.packed[n];
        }

        public int getSubsampledIndex(int n) {
            return (this.getSourceIndex(n) - this.first) / this.interval;
        }

        public int getPixelStride() {
            return (this.last - this.first) / this.interval + 1;
        }

        public GridExtent insertBandDimension(GridExtent gridExtent, int n) {
            this.first = this.getSourceIndex(0);
            this.last = this.getSourceIndex(this.packed.length - 1);
            return gridExtent.insertDimension(n, DimensionNameType.valueOf((String)"BAND"), this.first, this.last, true);
        }

        public int[] insertSubsampling(int[] nArray, int n) {
            int[] nArray2 = new int[this.packed.length - 1];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = this.getSourceIndex(i + 1) - this.getSourceIndex(i);
            }
            int[] nArray3 = MathFunctions.commonDivisors(nArray2);
            this.interval = nArray3.length != 0 ? nArray3[nArray3.length - 1] : 1;
            nArray = ArraysExt.insert(nArray, n, 1);
            nArray[n] = this.interval;
            return nArray;
        }

        public SampleDimension[] select(List<? extends SampleDimension> list) {
            SampleDimension[] sampleDimensionArray = new SampleDimension[this.getNumBands()];
            for (int i = 0; i < sampleDimensionArray.length; ++i) {
                sampleDimensionArray[this.getTargetIndex((int)i)] = list.get(this.getSourceIndex(i));
            }
            return sampleDimensionArray;
        }

        public SampleModel select(SampleModel sampleModel, boolean bl) {
            if (sampleModel == null || this.isIdentity()) {
                return sampleModel;
            }
            int[] nArray = this.getSelectedBands();
            if (bl) {
                return sampleModel.createSubsetSampleModel(nArray);
            }
            SampleModelFactory sampleModelFactory = new SampleModelFactory(sampleModel);
            sampleModelFactory.subsetAndCompress(nArray);
            return sampleModelFactory.build();
        }

        public ColorModel select(ColorModel colorModel) {
            if (colorModel == null || this.isIdentity()) {
                return colorModel;
            }
            return ColorModelFactory.createSubset(colorModel, this.getSelectedBands());
        }

        public SampleDimension.Builder builder() {
            if (this.builder == null) {
                this.builder = new SampleDimension.Builder();
            } else {
                this.builder.clear();
            }
            return this.builder;
        }
    }
}

