/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.jobs.JobDescription;

public class HopFilterManager
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: HopFilterManager.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String ownerIDField = "ownerid";
    public static final String linkTypeField = "linktype";
    public static final String maxHopsField = "maxhops";

    public HopFilterManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "jobhopfilters");
    }

    public void install(String ownerTable, String owningTablePrimaryKey) throws ManifoldCFException {
        block3: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(ownerIDField, new ColumnDescription("BIGINT", false, false, ownerTable, owningTablePrimaryKey, false));
                map.put(linkTypeField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(maxHopsField, new ColumnDescription("BIGINT", false, false, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription ownerIndex = new IndexDescription(true, new String[]{ownerIDField, linkTypeField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (ownerIndex != null && id.equals((Object)ownerIndex)) {
                    ownerIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (ownerIndex == null) break block3;
            this.performAddIndex(null, ownerIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public Map readRows(Long id) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(id);
        IResultSet set = this.performQuery("SELECT linktype,maxhops FROM " + this.getTableName() + " WHERE " + ownerIDField + "=?", list, null, null);
        HashMap<String, Long> rval = new HashMap<String, Long>();
        if (set.getRowCount() == 0) {
            return rval;
        }
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            String linkType = (String)row.getValue(linkTypeField);
            Long max = (Long)row.getValue(maxHopsField);
            rval.put(linkType, max);
        }
        return rval;
    }

    public void getRows(Map<Long, JobDescription> returnValues, String ownerIDList, ArrayList ownerIDParams) throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + ownerIDField + " IN (" + ownerIDList + ")", ownerIDParams, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            Long ownerID = (Long)row.getValue(ownerIDField);
            String linkType = (String)row.getValue(linkTypeField);
            Long maxHops = (Long)row.getValue(maxHopsField);
            returnValues.get(ownerID).addHopCountFilter(linkType, maxHops);
        }
    }

    public boolean compareRows(Long ownerID, IJobDescription list) throws ManifoldCFException {
        Map filterRows = this.readRows(ownerID);
        Map newFilterRows = list.getHopCountFilters();
        if (filterRows.size() != newFilterRows.size()) {
            return false;
        }
        for (String linkType : filterRows.keySet()) {
            Long oldCount = (Long)filterRows.get(linkType);
            Long newCount = (Long)newFilterRows.get(linkType);
            if (oldCount == null || newCount == null) {
                return false;
            }
            if (oldCount.longValue() == newCount.longValue()) continue;
            return false;
        }
        return true;
    }

    public void writeRows(Long ownerID, IJobDescription list) throws ManifoldCFException {
        this.beginTransaction();
        try {
            boolean i = false;
            HashMap<String, Object> map = new HashMap<String, Object>();
            Map filters = list.getHopCountFilters();
            for (String linkType : filters.keySet()) {
                Long maxHops = (Long)filters.get(linkType);
                map.clear();
                map.put(linkTypeField, linkType);
                map.put(maxHopsField, maxHops);
                map.put(ownerIDField, ownerID);
                this.performInsert(map, null);
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void deleteRows(Long ownerID) throws ManifoldCFException {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(ownerID);
        this.performDelete("WHERE ownerid=?", list, null);
    }
}

