/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.BaseCrawlerInitializationCommand;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class ImportConfiguration
extends BaseCrawlerInitializationCommand {
    public static final String _rcsid = "@(#)$Id: ImportConfiguration.java 988245 2010-08-23 18:39:35Z kwright $";
    private final String importFilename;
    private final String passCode;

    public ImportConfiguration(String importFilename, String passCode) {
        this.importFilename = importFilename;
        this.passCode = passCode;
    }

    @Override
    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        ManifoldCF.importConfiguration(tc, this.importFilename, this.passCode);
        Logging.root.info((Object)"Configuration imported");
    }

    public static void main(String[] args) {
        if (args.length != 1 && args.length != 2) {
            System.err.println("Usage: ImportConfiguration <filename> [<passcode>]");
            System.exit(1);
        }
        String importFilename = args[0];
        String passCode = args.length == 2 ? args[1] : null;
        try {
            ImportConfiguration importConfiguration = new ImportConfiguration(importFilename, passCode);
            importConfiguration.execute();
            System.err.println("Configuration imported");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

