/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.mappingconnectorpool;

import org.apache.manifoldcf.authorities.interfaces.IMappingConnection;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnectionManager;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnector;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnectorManager;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnectorPool;
import org.apache.manifoldcf.authorities.interfaces.MappingConnectionManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.MappingConnectorManagerFactory;
import org.apache.manifoldcf.core.connectorpool.ConnectorPool;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class MappingConnectorPool
implements IMappingConnectorPool {
    public static final String _rcsid = "@(#)$Id: MappingConnectorPool.java 1549105 2013-12-08 18:54:09Z kwright $";
    protected static final LocalPool localPool = new LocalPool();
    protected final IThreadContext threadContext;

    public MappingConnectorPool(IThreadContext threadContext) throws ManifoldCFException {
        this.threadContext = threadContext;
    }

    @Override
    public IMappingConnector[] grabMultiple(String[] orderingKeys, IMappingConnection[] mappingConnections) throws ManifoldCFException {
        String[] connectionNames = new String[mappingConnections.length];
        String[] classNames = new String[mappingConnections.length];
        ConfigParams[] configInfos = new ConfigParams[mappingConnections.length];
        int[] maxPoolSizes = new int[mappingConnections.length];
        for (int i = 0; i < mappingConnections.length; ++i) {
            connectionNames[i] = mappingConnections[i].getName();
            classNames[i] = mappingConnections[i].getClassName();
            configInfos[i] = mappingConnections[i].getConfigParams();
            maxPoolSizes[i] = mappingConnections[i].getMaxConnections();
        }
        return localPool.grabMultiple(this.threadContext, orderingKeys, connectionNames, classNames, configInfos, maxPoolSizes);
    }

    @Override
    public IMappingConnector grab(IMappingConnection mappingConnection) throws ManifoldCFException {
        return (IMappingConnector)localPool.grab(this.threadContext, mappingConnection.getName(), mappingConnection.getClassName(), mappingConnection.getConfigParams(), mappingConnection.getMaxConnections());
    }

    @Override
    public void releaseMultiple(IMappingConnection[] connections, IMappingConnector[] connectors) throws ManifoldCFException {
        String[] connectionNames = new String[connections.length];
        for (int i = 0; i < connections.length; ++i) {
            connectionNames[i] = connections[i].getName();
        }
        localPool.releaseMultiple(this.threadContext, connectionNames, connectors);
    }

    @Override
    public void release(IMappingConnection connection, IMappingConnector connector) throws ManifoldCFException {
        localPool.release(this.threadContext, connection.getName(), connector);
    }

    @Override
    public void pollAllConnectors() throws ManifoldCFException {
        localPool.pollAllConnectors(this.threadContext);
    }

    @Override
    public void flushUnusedConnectors() throws ManifoldCFException {
        localPool.flushUnusedConnectors(this.threadContext);
    }

    @Override
    public void closeAllConnectors() throws ManifoldCFException {
        localPool.closeAllConnectors(this.threadContext);
    }

    protected static class LocalPool
    extends ConnectorPool<IMappingConnector> {
        public LocalPool() {
            super("_MAPPINGCONNECTORPOOL_");
        }

        protected boolean isInstalled(IThreadContext tc, String className) throws ManifoldCFException {
            IMappingConnectorManager connectorManager = MappingConnectorManagerFactory.make(tc);
            return connectorManager.isInstalled(className);
        }

        protected boolean isConnectionNameValid(IThreadContext tc, String connectionName) throws ManifoldCFException {
            IMappingConnectionManager connectionManager = MappingConnectionManagerFactory.make(tc);
            return connectionManager.load(connectionName) != null;
        }

        public IMappingConnector[] grabMultiple(IThreadContext tc, String[] orderingKeys, String[] connectionNames, String[] classNames, ConfigParams[] configInfos, int[] maxPoolSizes) throws ManifoldCFException {
            return (IMappingConnector[])this.grabMultiple(tc, IMappingConnector.class, orderingKeys, connectionNames, classNames, configInfos, maxPoolSizes);
        }
    }
}

