/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.elasticsearch;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchConfig;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchConnection;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.system.Logging;

public class ElasticSearchDelete
extends ElasticSearchConnection {
    public ElasticSearchDelete(HttpClient client, ElasticSearchConfig config) {
        super(config, client);
    }

    public void execute(String documentURI) throws ManifoldCFException, ServiceInterruption {
        String idField = URLEncoder.encode((String)documentURI);
        HttpDelete method = new HttpDelete(this.config.getServerLocation() + "/" + this.config.getIndexName() + "/" + this.config.getIndexType() + "/" + idField);
        this.call((HttpRequestBase)method);
        String error = this.checkJson("\"error\"");
        if (this.getResult() == ElasticSearchConnection.Result.OK && error == null) {
            return;
        }
        this.setResult("JSONERROR", ElasticSearchConnection.Result.ERROR, error);
        Logging.connectors.warn((Object)("ES: Delete failed: " + this.getResponse()));
    }

    @Override
    protected boolean handleResultCode(int code, String response) throws ManifoldCFException, ServiceInterruption {
        if (code == 404) {
            this.setResult("OK", ElasticSearchConnection.Result.OK, null);
            return true;
        }
        return super.handleResultCode(code, response);
    }
}

