/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import java.time.Instant;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreException;

final class HYCOM {
    private static final Pattern DATE_PATTERN = Pattern.compile("days?\\s+as\\s+(?-i)%Y%m%d.*", 2);

    private HYCOM() {
    }

    static void convert(Decoder decoder, Variable[] variableArray) throws IOException, DataStoreException {
        Matcher matcher = null;
        for (Variable variable : variableArray) {
            String string;
            if (variable.getNumDimensions() != 1 || (string = variable.getUnitsString()) == null) continue;
            if (matcher == null) {
                matcher = DATE_PATTERN.matcher(string);
            } else {
                matcher.reset(string);
            }
            if (!matcher.matches()) continue;
            Dimension dimension = variable.getGridDimensions().get(0);
            Instant instant = variable.setUnit(decoder.findVariable(dimension.getName()), Units.DAY);
            if (instant == null) {
                instant = Instant.EPOCH;
            }
            long l = instant.toEpochMilli();
            Vector vector = variable.read();
            double[] dArray = new double[vector.size()];
            GregorianCalendar gregorianCalendar = new GregorianCalendar(decoder.getTimeZone(), Locale.US);
            gregorianCalendar.clear();
            for (int i = 0; i < dArray.length; ++i) {
                double d = vector.doubleValue(i);
                long l2 = (long)d;
                d -= (double)l2;
                int n = (int)(l2 % 100L);
                int n2 = (int)((l2 /= 100L) % 100L);
                gregorianCalendar.set(Math.toIntExact(l2 /= 100L), n2 - 1, n, 0, 0, 0);
                l2 = gregorianCalendar.getTimeInMillis() - l;
                dArray[i] = d += (double)l2 / 8.64E7;
            }
            variable.setValues(dArray);
        }
    }
}

