/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.googledrive;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.media.MediaHttpDownloader;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.connectorcommon.common.XThreadInputStream;
import org.apache.manifoldcf.connectorcommon.common.XThreadOutputStream;
import org.apache.manifoldcf.connectorcommon.common.XThreadStringBuffer;

public class GoogleDriveSession {
    private static String APPNAME = "ManifoldCF GoogleDrive Connector";
    private Drive drive;
    private HttpTransport HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();

    public GoogleDriveSession(String clientId, String clientSecret, String refreshToken) throws IOException, GeneralSecurityException {
        GoogleCredential credentials = new GoogleCredential.Builder().setClientSecrets(clientId, clientSecret).setJsonFactory(JSON_FACTORY).setTransport(this.HTTP_TRANSPORT).build().setRefreshToken(refreshToken);
        this.drive = new Drive.Builder(this.HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)credentials).setApplicationName(APPNAME).build();
    }

    public void close() {
    }

    public Map<String, String> getRepositoryInfo() throws IOException {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("Application Name", this.drive.getApplicationName());
        info.put("Base URL", this.drive.getBaseUrl());
        Drive.Files.Get get = this.drive.files().get("");
        get.setSupportsTeamDrives(Boolean.valueOf(true));
        get.execute();
        return info;
    }

    public void getSeeds(XThreadStringBuffer idBuffer, String googleDriveQuery) throws IOException, InterruptedException {
        Drive.Files.List request = this.drive.files().list().setQ(googleDriveQuery);
        request.setIncludeTeamDriveItems(Boolean.valueOf(true));
        request.setSupportsTeamDrives(Boolean.valueOf(true));
        do {
            FileList files = (FileList)request.execute();
            for (File f : files.getItems()) {
                idBuffer.add(f.getId());
            }
            request.setPageToken(files.getNextPageToken());
        } while (request.getPageToken() != null && request.getPageToken().length() > 0);
    }

    public File getObject(String id) throws IOException {
        Drive.Files.Get get = this.drive.files().get(id);
        get.setSupportsTeamDrives(Boolean.valueOf(true));
        File file = (File)get.execute();
        return file;
    }

    public void getChildren(XThreadStringBuffer idBuffer, String nodeId) throws IOException, InterruptedException {
        Drive.Files.List request = this.drive.files().list().setQ("'" + nodeId + "' in parents");
        request.setIncludeTeamDriveItems(Boolean.valueOf(true));
        request.setSupportsTeamDrives(Boolean.valueOf(true));
        do {
            FileList files = (FileList)request.execute();
            for (File f : files.getItems()) {
                idBuffer.add(f.getId());
            }
            request.setPageToken(files.getNextPageToken());
        } while (request.getPageToken() != null && request.getPageToken().length() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getGoogleDriveOutputStream(XThreadInputStream inputStream, String documentURI) throws IOException {
        try (XThreadOutputStream outputStream = new XThreadOutputStream(inputStream);){
            MediaHttpDownloader downloader = new MediaHttpDownloader(this.HTTP_TRANSPORT, this.drive.getRequestFactory().getInitializer());
            downloader.setDirectDownloadEnabled(false);
            downloader.download(new GenericUrl(documentURI), (OutputStream)outputStream);
        }
    }
}

