/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.fs.stream;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3OutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(S3OutputStream.class);
    private final String bucket;
    private final String path;
    int BUFFER_SIZE = 0x500000;
    private final byte[] buf = new byte[this.BUFFER_SIZE];
    private byte[] flashBuffer;
    private int position = 0;
    private final AmazonS3 s3Client;
    private String uploadId;
    private final List<PartETag> etags = new ArrayList<PartETag>();

    public S3OutputStream(AmazonS3 s3Client, String bucket, String path) {
        if (s3Client == null) {
            throw new IllegalArgumentException("The s3Client cannot be null.");
        }
        if (bucket == null || bucket.isEmpty()) {
            throw new IllegalArgumentException("The bucket cannot be null or an empty string.");
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("The path cannot be null or an empty string.");
        }
        this.s3Client = s3Client;
        this.bucket = bucket;
        this.path = path;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] byteArray, int o, int l) {
        int len;
        int size;
        int ofs = o;
        for (len = l; len > (size = this.buf.length - this.position); len -= size) {
            System.arraycopy(byteArray, ofs, this.buf, this.position, size);
            this.position += size;
            this.flushBufferAndRewind();
            ofs += size;
        }
        System.arraycopy(byteArray, ofs, this.buf, this.position, len);
        this.position += len;
    }

    @Override
    public synchronized void flush() {
    }

    protected void flushBufferAndRewind() {
        if (this.uploadId == null) {
            LOG.info("Starting a multipart upload for {}/{}", (Object)this.bucket, (Object)this.path);
            try {
                InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.bucket, this.path).withCannedACL(CannedAccessControlList.BucketOwnerFullControl);
                InitiateMultipartUploadResult initResponse = this.s3Client.initiateMultipartUpload(request);
                this.uploadId = initResponse.getUploadId();
            }
            catch (AmazonS3Exception e) {
                LOG.error("Failed to start multipart upload: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
        }
        try {
            this.uploadPart();
        }
        catch (AmazonS3Exception e) {
            LOG.error("Failed to upload part: {}", (Object)e.getMessage(), (Object)e);
            this.s3Client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucket, this.path, this.uploadId));
            throw new RuntimeException(e);
        }
        this.position = 0;
    }

    protected void uploadPart() {
        LOG.debug("Uploading part {}", (Object)this.etags.size());
        try {
            UploadPartResult uploadResult = this.s3Client.uploadPart(new UploadPartRequest().withBucketName(this.bucket).withKey(this.path).withUploadId(this.uploadId).withInputStream((InputStream)new ByteArrayInputStream(this.buf, 0, this.position)).withPartNumber(this.etags.size() + 1).withPartSize((long)this.position));
            this.etags.add(uploadResult.getPartETag());
        }
        catch (AmazonS3Exception e) {
            LOG.error("Failed to upload part: {}", (Object)e.getMessage(), (Object)e);
            this.s3Client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucket, this.path, this.uploadId));
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.uploadId != null) {
            if (this.position > 0) {
                this.uploadPart();
            }
            LOG.debug("Completing multipart");
            try {
                this.s3Client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucket, this.path, this.uploadId, this.etags));
            }
            catch (AmazonS3Exception e) {
                LOG.error("Failed to complete multipart upload: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
        }
        LOG.debug("Uploading object at once to {}/{}", (Object)this.bucket, (Object)this.path);
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)this.position);
            PutObjectRequest request = new PutObjectRequest(this.bucket, this.path, (InputStream)new ByteArrayInputStream(this.buf, 0, this.position), metadata).withCannedAcl(CannedAccessControlList.BucketOwnerFullControl);
            this.s3Client.putObject(request);
        }
        catch (AmazonS3Exception e) {
            LOG.error("Failed to upload object: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void cancel() {
        if (this.uploadId != null) {
            try {
                LOG.debug("Aborting multipart upload");
                this.s3Client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucket, this.path, this.uploadId));
            }
            catch (AmazonS3Exception e) {
                LOG.error("Failed to abort multipart upload: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Override
    public void write(int b) {
        if (this.position >= this.buf.length) {
            this.flushBufferAndRewind();
        }
        this.buf[this.position++] = (byte)b;
    }
}

