/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Path;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mapstruct.BeforeMapping;
import org.mapstruct.Context;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Header;
import springfox.documentation.service.ModelNamesRegistry;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Representation;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.service.Response;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.swagger2.mappers.CompatibilityModelMapper;
import springfox.documentation.swagger2.mappers.ExamplesMapper;
import springfox.documentation.swagger2.mappers.LicenseMapper;
import springfox.documentation.swagger2.mappers.ModelMapper;
import springfox.documentation.swagger2.mappers.ModelSpecificationMapper;
import springfox.documentation.swagger2.mappers.ParameterMapper;
import springfox.documentation.swagger2.mappers.PropertyMapper;
import springfox.documentation.swagger2.mappers.RequestParameterMapper;
import springfox.documentation.swagger2.mappers.SecurityMapper;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Mapper(uses={CompatibilityModelMapper.class, SecurityMapper.class, LicenseMapper.class, VendorExtensionsMapper.class}, componentModel="spring")
public abstract class ServiceModelToSwagger2Mapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceModelToSwagger2Mapper.class);
    @Autowired
    @Value(value="${springfox.documentation.swagger.use-model-v3:true}")
    boolean useModelV3;

    @Mappings(value={@Mapping(target="info", source="resourceListing.info"), @Mapping(target="paths", source="apiListings"), @Mapping(target="host", source="host"), @Mapping(target="schemes", source="schemes"), @Mapping(target="definitions", source="apiListings"), @Mapping(target="securityDefinitions", source="resourceListing"), @Mapping(target="securityRequirement", ignore=true), @Mapping(target="security", ignore=true), @Mapping(target="swagger", ignore=true), @Mapping(target="parameters", ignore=true), @Mapping(target="responses", ignore=true), @Mapping(target="externalDocs", ignore=true), @Mapping(target="vendorExtensions", source="vendorExtensions"), @Mapping(target="tag", ignore=true), @Mapping(target="scheme", ignore=true)})
    public abstract Swagger mapDocumentation(Documentation var1);

    @Mappings(value={@Mapping(target="license", source="from", qualifiedBy={LicenseMapper.LicenseTranslator.class, LicenseMapper.License.class}), @Mapping(target="contact", source="from.contact"), @Mapping(target="termsOfService", source="termsOfServiceUrl"), @Mapping(target="vendorExtensions", source="vendorExtensions"), @Mapping(target="mergeWith", ignore=true)})
    protected abstract Info mapApiInfo(ApiInfo var1);

    protected abstract io.swagger.models.Contact map(Contact var1);

    @BeforeMapping
    void beforeMappingOperations(@MappingTarget io.swagger.models.Operation target, Operation source, @Context ModelNamesRegistry modelNamesRegistry) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (this.useModelV3) {
            for (RequestParameter each : source.getRequestParameters()) {
                parameters.addAll(((RequestParameterMapper)Mappers.getMapper(RequestParameterMapper.class)).mapParameter(each, modelNamesRegistry));
            }
            target.setResponses(this.mapResponses(source.getResponses(), modelNamesRegistry));
        } else {
            for (springfox.documentation.service.Parameter each : source.getParameters()) {
                parameters.add(((ParameterMapper)Mappers.getMapper(ParameterMapper.class)).mapParameter(each));
            }
            target.setResponses(this.mapResponseMessages(source.getResponseMessages()));
        }
        target.setParameters(parameters);
    }

    @Mappings(value={@Mapping(target="description", source="notes"), @Mapping(target="operationId", source="uniqueId"), @Mapping(target="schemes", source="protocol"), @Mapping(target="security", source="securityReferences"), @Mapping(target="responses", ignore=true), @Mapping(target="vendorExtensions", source="vendorExtensions"), @Mapping(target="externalDocs", ignore=true), @Mapping(target="scheme", ignore=true), @Mapping(target="defaultResponse", ignore=true), @Mapping(target="tag", ignore=true), @Mapping(target="parameter", ignore=true), @Mapping(target="parameters", ignore=true)})
    protected abstract io.swagger.models.Operation mapOperation(Operation var1, @Context ModelNamesRegistry var2);

    @Mappings(value={@Mapping(target="externalDocs", ignore=true), @Mapping(target="vendorExtensions", source="vendorExtensions")})
    protected abstract Tag mapTag(springfox.documentation.service.Tag var1);

    protected List<Scheme> mapSchemes(List<String> from) {
        return from.stream().map(Scheme::forValue).collect(Collectors.toList());
    }

    protected List<Map<String, List<String>>> mapAuthorizations(Map<String, List<AuthorizationScope>> from) {
        ArrayList<Map<String, List<String>>> security = new ArrayList<Map<String, List<String>>>();
        for (Map.Entry<String, List<AuthorizationScope>> each : from.entrySet()) {
            HashMap newEntry = new HashMap();
            newEntry.put(each.getKey(), each.getValue().stream().map(AuthorizationScope::getScope).collect(Collectors.toList()));
            security.add(newEntry);
        }
        return security;
    }

    @Deprecated
    protected Map<String, io.swagger.models.Response> mapResponseMessages(Set<ResponseMessage> from) {
        TreeMap<String, io.swagger.models.Response> responses = new TreeMap<String, io.swagger.models.Response>();
        for (ResponseMessage responseMessage : from) {
            ModelReference modelRef = responseMessage.getResponseModel();
            Property responseProperty = this.modelRefToProperty(modelRef);
            io.swagger.models.Response response = new io.swagger.models.Response().description(responseMessage.getMessage()).schema(responseProperty);
            Map<String, Object> examples = new ExamplesMapper().mapExamples(responseMessage.getExamples());
            response.setExamples(examples);
            response.setHeaders(responseMessage.getHeaders().entrySet().stream().map(this.toPropertyEntry()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            Map<String, Object> extensions = new VendorExtensionsMapper().mapExtensions(responseMessage.getVendorExtensions());
            response.getVendorExtensions().putAll(extensions);
            responses.put(String.valueOf(responseMessage.getCode()), response);
        }
        return responses;
    }

    protected Map<String, io.swagger.models.Response> mapResponses(Set<Response> from, ModelNamesRegistry modelNamesRegistry) {
        TreeMap<String, io.swagger.models.Response> responses = new TreeMap<String, io.swagger.models.Response>();
        for (Response each : from) {
            io.swagger.models.Response response = new io.swagger.models.Response().description(each.getDescription());
            for (Representation representation : each.getRepresentations()) {
                Model responseModel = ((ModelSpecificationMapper)Mappers.getMapper(ModelSpecificationMapper.class)).mapModels(representation.getModel(), modelNamesRegistry);
                Property property = ((PropertyMapper)Mappers.getMapper(PropertyMapper.class)).fromModel(representation.getModel(), modelNamesRegistry);
                response.setResponseSchema(responseModel);
                response.schema(property);
            }
            response.setHeaders(each.getHeaders().stream().collect(Collectors.toMap(Header::getName, h -> ((PropertyMapper)Mappers.getMapper(PropertyMapper.class)).fromModel(h.getModelSpecification(), modelNamesRegistry))));
            Map<String, Object> extensions = new VendorExtensionsMapper().mapExtensions(each.getVendorExtensions());
            response.getVendorExtensions().putAll(extensions);
            Map<String, Object> examples = new ExamplesMapper().mapExamples(each.getExamples());
            response.setExamples(examples);
            responses.put(String.valueOf(each.getCode()), response);
        }
        return responses;
    }

    private Function<Map.Entry<String, Header>, Map.Entry<String, Property>> toPropertyEntry() {
        return entry -> {
            Property property = this.modelRefToProperty(((Header)entry.getValue()).getModelReference());
            property.setDescription(((Header)entry.getValue()).getDescription());
            return new AbstractMap.SimpleEntry<String, Property>((String)entry.getKey(), property);
        };
    }

    private Property modelRefToProperty(ModelReference modelReference) {
        return ModelMapper.modelRefToProperty(modelReference);
    }

    protected Map<String, Path> mapApiListings(Map<String, List<ApiListing>> apiListings) {
        TreeMap<String, Path> paths = new TreeMap<String, Path>();
        apiListings.values().stream().flatMap(Collection::stream).forEachOrdered(each -> {
            for (ApiDescription api : each.getApis()) {
                LOGGER.debug("Mapping operation with path {}", (Object)api.getPath());
                paths.put(api.getPath(), this.mapOperations(api, Optional.ofNullable((Path)paths.get(api.getPath())), each.getModelNamesRegistry()));
            }
        });
        return paths;
    }

    private Path mapOperations(ApiDescription api, Optional<Path> existingPath, ModelNamesRegistry modelNamesRegistry) {
        Path path = existingPath.orElse(new Path());
        for (Operation each : BuilderDefaults.nullToEmptyList((Collection)api.getOperations())) {
            io.swagger.models.Operation operation = this.mapOperation(each, modelNamesRegistry);
            path.set(each.getMethod().toString().toLowerCase(), operation);
        }
        return path;
    }
}

