/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.redis.stream;

import com.redislabs.provider.redis.RedisConfig;
import com.redislabs.provider.redis.RedisConfig$;
import com.redislabs.provider.redis.util.CollectionUtils$;
import com.redislabs.provider.redis.util.CollectionUtils$RichCollection$;
import com.redislabs.provider.redis.util.ConnectionUtils$;
import com.redislabs.provider.redis.util.Logging;
import com.redislabs.provider.redis.util.ParseUtils$;
import com.redislabs.provider.redis.util.StreamUtils$;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.redis.stream.RedisConsumerConfig;
import org.apache.spark.sql.redis.stream.RedisConsumerOffset;
import org.apache.spark.sql.redis.stream.RedisSource$;
import org.apache.spark.sql.redis.stream.RedisSourceConfig;
import org.apache.spark.sql.redis.stream.RedisSourceConfig$;
import org.apache.spark.sql.redis.stream.RedisSourceOffset;
import org.apache.spark.sql.redis.stream.RedisSourceOffsetRange;
import org.apache.spark.sql.redis.stream.RedisSourceRdd;
import org.apache.spark.sql.redis.stream.RedisSourceRdd$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.StreamEntryID;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u000e\u001d\u0001%B\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A!\f\u0001B\u0001B\u0003%1\f\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003g\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u001d\t\bA1A\u0005\nIDaa\u001e\u0001!\u0002\u0013\u0019\bb\u0002=\u0001\u0005\u0004%Y!\u001f\u0005\u0007}\u0002\u0001\u000b\u0011\u0002>\t\u0011}\u0004!\u0019!C\u0005\u0003\u0003A\u0001\"!\u0003\u0001A\u0003%\u00111\u0001\u0005\n\u0003\u0017\u0001!\u0019!C\u0005\u0003\u001bAq!a\u0004\u0001A\u0003%q\fC\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u000e!9\u0011Q\u0004\u0001\u0005B\u0005}\u0001bBA\u0015\u0001\u0011\u0005\u00131\u0006\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\t9\u0006\u0001C!\u0003'Aq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002x\u0001!I!!\u001f\b\u000f\u0005mE\u0004#\u0001\u0002\u001e\u001a11\u0004\bE\u0001\u0003?Ca![\f\u0005\u0002\u0005\u001d\u0006bBAU/\u0011\u0005\u00111\u0016\u0005\b\u0003{;B\u0011AA`\u0005-\u0011V\rZ5t'>,(oY3\u000b\u0005uq\u0012AB:ue\u0016\fWN\u0003\u0002 A\u0005)!/\u001a3jg*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M!\u0001A\u000b\u001a;!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0003mC:<'\"A\u0018\u0002\t)\fg/Y\u0005\u0003c1\u0012aa\u00142kK\u000e$\bCA\u001a9\u001b\u0005!$BA\u001b7\u0003%\u0019HO]3b[&twM\u0003\u00028A\u0005IQ\r_3dkRLwN\\\u0005\u0003sQ\u0012aaU8ve\u000e,\u0007CA\u001eF\u001b\u0005a$BA\u001f?\u0003\u0011)H/\u001b7\u000b\u0005}y$B\u0001!B\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001\"D\u0003%\u0011X\rZ5tY\u0006\u00147OC\u0001E\u0003\r\u0019w.\\\u0005\u0003\rr\u0012q\u0001T8hO&tw-\u0001\u0006tc2\u001cuN\u001c;fqR\u0004\"!\u0013&\u000e\u0003\u0001J!a\u0013\u0011\u0003\u0015M\u000bFjQ8oi\u0016DH/\u0001\u0007nKR\fG-\u0019;b!\u0006$\b\u000e\u0005\u0002O/:\u0011q*\u0016\t\u0003!Nk\u0011!\u0015\u0006\u0003%\"\na\u0001\u0010:p_Rt$\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b\u0016A\u0002)sK\u0012,g-\u0003\u0002Y3\n11\u000b\u001e:j]\u001eT!AV*\u0002#U\u001cXM\u001d#fM&tW\rZ*dQ\u0016l\u0017\rE\u0002];~k\u0011aU\u0005\u0003=N\u0013aa\u00149uS>t\u0007C\u00011d\u001b\u0005\t'B\u00012!\u0003\u0015!\u0018\u0010]3t\u0013\t!\u0017M\u0001\u0006TiJ,8\r\u001e+za\u0016\f!\u0002]1sC6,G/\u001a:t!\u0011qu-T'\n\u0005!L&aA'ba\u00061A(\u001b8jiz\"Ra[7o_B\u0004\"\u0001\u001c\u0001\u000e\u0003qAQaR\u0003A\u0002!CQ\u0001T\u0003A\u00025CQAW\u0003A\u0002mCQ!Z\u0003A\u0002\u0019\f!a]2\u0016\u0003M\u0004\"\u0001^;\u000e\u0003\tJ!A\u001e\u0012\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\u0002\u0007M\u001c\u0007%A\u0006sK\u0012L7oQ8oM&<W#\u0001>\u0011\u0005mdX\"\u0001 \n\u0005ut$a\u0003*fI&\u001c8i\u001c8gS\u001e\fAB]3eSN\u001cuN\u001c4jO\u0002\nAb]8ve\u000e,7i\u001c8gS\u001e,\"!a\u0001\u0011\u00071\f)!C\u0002\u0002\bq\u0011\u0011CU3eSN\u001cv.\u001e:dK\u000e{gNZ5h\u00035\u0019x.\u001e:dK\u000e{gNZ5hA\u0005i1-\u001e:sK:$8k\u00195f[\u0006,\u0012aX\u0001\u000fGV\u0014(/\u001a8u'\u000eDW-\\1!\u0003\u0015\u0019H/\u0019:u)\t\t)\u0002E\u0002]\u0003/I1!!\u0007T\u0005\u0011)f.\u001b;\u0002\rM\u001c\u0007.Z7b\u0003%9W\r^(gMN,G/\u0006\u0002\u0002\"A!A,XA\u0012!\r\u0019\u0014QE\u0005\u0004\u0003O!$AB(gMN,G/\u0001\u0005hKR\u0014\u0015\r^2i)\u0019\ti#a\u0013\u0002NA!\u0011qFA#\u001d\u0011\t\t$!\u0011\u000f\t\u0005M\u0012q\b\b\u0005\u0003k\tiD\u0004\u0003\u00028\u0005mbb\u0001)\u0002:%\tq%\u0003\u0002&M%\u00111\u0005J\u0005\u0003C\tJ1!a\u0011!\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0012\u0002J\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003\u0007\u0002\u0003bBA\t#\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003\u001f\n\u0002\u0019AA\u0012\u0003\r)g\u000eZ\u0001\u0007G>lW.\u001b;\u0015\t\u0005U\u0011Q\u000b\u0005\b\u0003\u001f\u0012\u0002\u0019AA\u0012\u0003\u0011\u0019Ho\u001c9\u0002=I,7/\u001a;D_:\u001cX/\\3s\u000fJ|W\u000f]:JM\"\u000b7o\u00144gg\u0016$H\u0003BA\u000b\u0003;Bq!a\u0018\u0015\u0001\u0004\t\t'\u0001\u0007pM\u001a\u001cX\r\u001e*b]\u001e,7\u000f\u0005\u0004\u0002d\u0005-\u0014\u0011\u000f\b\u0005\u0003K\nIGD\u0002Q\u0003OJ\u0011\u0001V\u0005\u0004\u0003\u0007\u001a\u0016\u0002BA7\u0003_\u00121aU3r\u0015\r\t\u0019e\u0015\t\u0004Y\u0006M\u0014bAA;9\t1\"+\u001a3jgN{WO]2f\u001f\u001a47/\u001a;SC:<W-\u0001\u0014g_J,\u0015m\u00195PM\u001a\u001cX\r\u001e*b]\u001e,w+\u001b;i'R\u0014X-Y7D_:tWm\u0019;j_:$B!a\u001f\u0002\u001aR!\u0011QCA?\u0011\u001d\ty(\u0006a\u0001\u0003\u0003\u000b!a\u001c9\u0011\u0013q\u000b\u0019)a\"\u0002r\u0005U\u0011bAAC'\nIa)\u001e8di&|gN\r\t\u0005\u0003\u0013\u000b)*\u0004\u0002\u0002\f*!\u0011QRAH\u0003\u0015QW\rZ5t\u0015\u0011\t\t*a%\u0002\u000f\rd\u0017.\u001a8ug*\tq$\u0003\u0003\u0002\u0018\u0006-%!\u0002&fI&\u001c\bbBA0+\u0001\u0007\u0011\u0011M\u0001\f%\u0016$\u0017n]*pkJ\u001cW\r\u0005\u0002m/M\u0019q#!)\u0011\u0007q\u000b\u0019+C\u0002\u0002&N\u0013a!\u00118z%\u00164GCAAO\u0003=9W\r^(gMN,GOU1oO\u0016\u001cH\u0003CA1\u0003[\u000by+!-\t\u000f\u0005E\u0011\u00041\u0001\u0002\"!9\u0011qJ\rA\u0002\u0005\r\u0002bBAZ3\u0001\u0007\u0011QW\u0001\u0010G>t7/^7fe\u000e{gNZ5hgB1\u00111MA6\u0003o\u00032\u0001\\A]\u0013\r\tY\f\b\u0002\u0014%\u0016$\u0017n]\"p]N,X.\u001a:D_:4\u0017nZ\u0001\rgR\u0014X-Y7MCN$\u0018\n\u001a\u000b\u0006\u001b\u0006\u0005\u0017Q\u0019\u0005\b\u0003\u0007T\u0002\u0019AAD\u0003\u0011\u0019wN\u001c8\t\r\u0005\u001d'\u00041\u0001N\u0003%\u0019HO]3b[.+\u0017\u0010")
public class RedisSource
implements Source,
Logging {
    private final SQLContext sqlContext;
    private final SparkContext sc;
    private final RedisConfig redisConfig;
    private final RedisSourceConfig sourceConfig;
    private final StructType currentSchema;
    private transient Logger com$redislabs$provider$redis$util$Logging$$_logger;

    public static String streamLastId(Jedis jedis, String string) {
        return RedisSource$.MODULE$.streamLastId(jedis, string);
    }

    public static Seq<RedisSourceOffsetRange> getOffsetRanges(Option<Offset> option, Offset offset, Seq<RedisConsumerConfig> seq) {
        return RedisSource$.MODULE$.getOffsetRanges(option, offset, seq);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public Logger com$redislabs$provider$redis$util$Logging$$_logger() {
        return this.com$redislabs$provider$redis$util$Logging$$_logger;
    }

    @Override
    public void com$redislabs$provider$redis$util$Logging$$_logger_$eq(Logger x$1) {
        this.com$redislabs$provider$redis$util$Logging$$_logger = x$1;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private RedisConfig redisConfig() {
        return this.redisConfig;
    }

    private RedisSourceConfig sourceConfig() {
        return this.sourceConfig;
    }

    private StructType currentSchema() {
        return this.currentSchema;
    }

    public void start() {
        this.sourceConfig().consumerConfigs().foreach((Function1 & Serializable & scala.Serializable)consumerConfig -> {
            RedisSource.$anonfun$start$1(this, consumerConfig);
            return BoxedUnit.UNIT;
        });
    }

    public StructType schema() {
        return this.currentSchema();
    }

    public Option<Offset> getOffset() {
        RedisSourceOffset initialOffset = new RedisSourceOffset((scala.collection.immutable.Map<String, RedisConsumerOffset>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        RedisSourceOffset sourceOffset = (RedisSourceOffset)((Object)this.sourceConfig().consumerConfigs().foldLeft((Object)initialOffset, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2((Object)x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RedisSourceOffset acc = (RedisSourceOffset)((Object)((Object)tuple2._1()));
            RedisConsumerConfig e = (RedisConsumerConfig)tuple2._2();
            String streamKey = e.streamKey();
            RedisSourceOffset redisSourceOffset = (RedisSourceOffset)((Object)((Object)ConnectionUtils$.MODULE$.withConnection(streamKey, (Function1 & Serializable & scala.Serializable)conn -> (RedisSourceOffset)((Object)((Object)((Object)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String offsetId = RedisSource$.MODULE$.streamLastId((Jedis)conn, streamKey);
                Tuple2 streamOffset = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)streamKey), (Object)new RedisConsumerOffset(e.groupName(), offsetId));
                return acc.copy((scala.collection.immutable.Map<String, RedisConsumerOffset>)acc.offsets().$plus(streamOffset));
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> acc)))), this.redisConfig())));
            return redisSourceOffset;
        }));
        return sourceOffset.offsets().isEmpty() ? None$.MODULE$ : new Some((Object)sourceOffset);
    }

    public Dataset<Row> getBatch(Option<Offset> start, Offset end) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(61).append("Getting batch...\n         |  start: ").append(start).append("\n         |  end: ").append(end).append("\n      ").toString())).stripMargin());
        StructType localSchema = this.currentSchema();
        Seq<RedisSourceOffsetRange> offsetRanges = RedisSource$.MODULE$.getOffsetRanges(start, end, this.sourceConfig().consumerConfigs());
        this.resetConsumerGroupsIfHasOffset(offsetRanges);
        RDD internalRdd = new RedisSourceRdd(this.sc(), this.redisConfig(), offsetRanges, RedisSourceRdd$.MODULE$.$lessinit$greater$default$4()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StreamEntryID id = (StreamEntryID)tuple2._1();
            Map fields = (Map)tuple2._2();
            scala.collection.immutable.Map fieldMap = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(fields).asScala()).toMap(Predef$.MODULE$.$conforms()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_id"), (Object)id.toString()));
            Object[] values = (Object[])Predef$.MODULE$.genericArrayOps((Object)ParseUtils$.MODULE$.parseFields((scala.collection.immutable.Map<String, String>)fieldMap, localSchema)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Object object;
                Object object2 = x0$2;
                if (object2 instanceof String) {
                    String string = (String)object2;
                    object = UTF8String.fromString((String)string);
                } else if (object2 instanceof Object) {
                    Object object3 = object2;
                    object = object3;
                } else {
                    throw new MatchError(object2);
                }
                return object;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
            InternalRow internalRow = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)values));
            return internalRow;
        }, ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sqlContext.internalCreateDataFrame(internalRdd, this.schema(), true);
    }

    public void commit(Offset end) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(48).append("Committing offset..\n         |  end: ").append(end.json()).append("\n         |").toString())).stripMargin());
    }

    public void stop() {
    }

    private void resetConsumerGroupsIfHasOffset(Seq<RedisSourceOffsetRange> offsetRanges) {
        this.forEachOffsetRangeWithStreamConnection(offsetRanges, (Function2<Jedis, RedisSourceOffsetRange, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            RedisSource.$anonfun$resetConsumerGroupsIfHasOffset$1(x0$1, x1$1);
            return BoxedUnit.UNIT;
        });
    }

    private void forEachOffsetRangeWithStreamConnection(Seq<RedisSourceOffsetRange> offsetRanges, Function2<Jedis, RedisSourceOffsetRange, BoxedUnit> op) {
        offsetRanges.groupBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.config().streamKey()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RedisSource.$anonfun$forEachOffsetRangeWithStreamConnection$2(this, op, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$start$6(String streamKey$1, String groupName$1, Option configOffsetOption$1, Jedis conn) {
        StreamUtils$.MODULE$.createConsumerGroupIfNotExist(conn, streamKey$1, groupName$1, (StreamEntryID)configOffsetOption$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> StreamEntryID.LAST_ENTRY));
        configOffsetOption$1.foreach((Function1 & Serializable & scala.Serializable)offset -> {
            StreamUtils$.MODULE$.resetConsumerGroup(conn, streamKey$1, groupName$1, offset);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$start$1(RedisSource $this, RedisConsumerConfig consumerConfig) {
        scala.collection.immutable.Map offsetsByStreamKey = (scala.collection.immutable.Map)$this.sourceConfig().start().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.offsets()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        String streamKey = consumerConfig.streamKey();
        String groupName = consumerConfig.groupName();
        Option configOffsetOption = offsetsByStreamKey.get((Object)streamKey).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.offset()).map((Function1 & Serializable & scala.Serializable)x$3 -> new StreamEntryID(x$3));
        ConnectionUtils$.MODULE$.withConnection(streamKey, (Function1 & Serializable & scala.Serializable)conn -> {
            RedisSource.$anonfun$start$6(streamKey, groupName, configOffsetOption, conn);
            return BoxedUnit.UNIT;
        }, $this.redisConfig());
    }

    public static final /* synthetic */ void $anonfun$resetConsumerGroupsIfHasOffset$3(RedisSourceOffsetRange offsetRange$1, Jedis conn$3, StreamEntryID start) {
        RedisConsumerConfig config = offsetRange$1.config();
        StreamUtils$.MODULE$.resetConsumerGroup(conn$3, config.streamKey(), config.groupName(), start);
    }

    public static final /* synthetic */ void $anonfun$resetConsumerGroupsIfHasOffset$1(Jedis x0$1, RedisSourceOffsetRange x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Jedis conn = (Jedis)tuple2._1();
        RedisSourceOffsetRange offsetRange = (RedisSourceOffsetRange)tuple2._2();
        offsetRange.start().map((Function1 & Serializable & scala.Serializable)x$4 -> new StreamEntryID(x$4)).foreach((Function1 & Serializable & scala.Serializable)start -> {
            RedisSource.$anonfun$resetConsumerGroupsIfHasOffset$3(offsetRange, conn, start);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$forEachOffsetRangeWithStreamConnection$3(Seq subRanges$1, Function2 op$1, Jedis conn) {
        ((IterableLike)CollectionUtils$RichCollection$.MODULE$.distinctBy$extension(CollectionUtils$.MODULE$.RichCollection(subRanges$1), (Function1 & Serializable & scala.Serializable)x$6 -> x$6.config().groupName(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)offsetRange -> {
            op$1.apply((Object)conn, (Object)offsetRange);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$forEachOffsetRangeWithStreamConnection$2(RedisSource $this, Function2 op$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String streamKey = (String)tuple2._1();
        Seq subRanges = (Seq)tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)ConnectionUtils$.MODULE$.withConnection(streamKey, (Function1 & Serializable & scala.Serializable)conn -> {
            RedisSource.$anonfun$forEachOffsetRangeWithStreamConnection$3(subRanges, op$1, conn);
            return BoxedUnit.UNIT;
        }, $this.redisConfig());
    }

    public RedisSource(SQLContext sqlContext, String metadataPath, Option<StructType> userDefinedSchema, scala.collection.immutable.Map<String, String> parameters) {
        this.sqlContext = sqlContext;
        Source.$init$((Source)this);
        Logging.$init$(this);
        this.sc = sqlContext.sparkContext();
        this.redisConfig = RedisConfig$.MODULE$.fromSparkConf(this.sc().getConf());
        this.sourceConfig = RedisSourceConfig$.MODULE$.fromMap(parameters);
        this.currentSchema = (StructType)userDefinedSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Please specify schema");
        });
    }
}

