/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl;

import com.github.pjfanning.xlsx.impl.OoxmlEvaluationCell;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.util.Internal;

@Internal
final class CurrentRowEvaluationSheet
implements EvaluationSheet {
    private final Sheet _xs;
    private final Row _row;

    CurrentRowEvaluationSheet(Sheet sheet, Row row) {
        this._xs = sheet;
        this._row = row;
    }

    Sheet getSheet() {
        return this._xs;
    }

    public int getLastRowNum() {
        return this._xs.getLastRowNum();
    }

    public boolean isRowHidden(int rowIndex) {
        if (this._row == null) {
            return false;
        }
        return this._row.getZeroHeight();
    }

    public EvaluationCell getCell(int rowIndex, int columnIndex) {
        if (this._row == null) {
            return null;
        }
        Cell cell = this._row.getCell(columnIndex);
        if (cell == null) {
            return null;
        }
        return new OoxmlEvaluationCell(cell, this);
    }

    public void clearAllCachedResultValues() {
    }
}

