/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseConfiguration
extends AbstractConfiguration
implements Cloneable {
    private Map<String, Object> store = new LinkedHashMap<String, Object>();

    @Override
    protected void addPropertyDirect(String key, Object value) {
        Object previousValue = this.getProperty(key);
        if (previousValue == null) {
            this.store.put(key, value);
        } else if (previousValue instanceof List) {
            List valueList = (List)previousValue;
            valueList.add(value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(previousValue);
            list.add(value);
            this.store.put(key, list);
        }
    }

    @Override
    public Object getProperty(String key) {
        return this.store.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        return this.store.containsKey(key);
    }

    @Override
    protected void clearPropertyDirect(String key) {
        if (this.containsKey(key)) {
            this.store.remove(key);
        }
    }

    @Override
    public void clear() {
        this.fireEvent(4, null, null, true);
        this.store.clear();
        this.fireEvent(4, null, null, false);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.store.keySet().iterator();
    }

    @Override
    public Object clone() {
        try {
            Map clonedStore;
            BaseConfiguration copy = (BaseConfiguration)super.clone();
            copy.store = clonedStore = (Map)ConfigurationUtils.clone(this.store);
            for (Map.Entry<String, Object> e : this.store.entrySet()) {
                if (!(e.getValue() instanceof Collection)) continue;
                Collection strList = (Collection)e.getValue();
                copy.store.put(e.getKey(), new ArrayList(strList));
            }
            return copy;
        }
        catch (CloneNotSupportedException cex) {
            throw new ConfigurationRuntimeException(cex);
        }
    }
}

