/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.conf.LabelCommonConfig;
import org.apache.linkis.manager.label.entity.engine.EngineType;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;

public class EngineTypeLabelCreator {
    private static LabelBuilderFactory labelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
    private static Map<String, String> defaultVersion = null;
    public static final String ENGINE_TYPE = "engineType";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (null != defaultVersion) return;
        Class<EngineTypeLabelCreator> clazz = EngineTypeLabelCreator.class;
        synchronized (EngineTypeLabelCreator.class) {
            if (null != defaultVersion) return;
            defaultVersion = new HashMap<String, String>(16);
            defaultVersion.put(EngineType.SPARK().toString(), (String)LabelCommonConfig.SPARK_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.HIVE().toString(), (String)LabelCommonConfig.HIVE_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.PYTHON().toString(), (String)LabelCommonConfig.PYTHON_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.REPL().toString(), (String)LabelCommonConfig.REPL_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.IO_ENGINE_FILE().toString(), (String)LabelCommonConfig.FILE_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.IO_ENGINE_HDFS().toString(), (String)LabelCommonConfig.HDFS_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.JDBC().toString(), (String)LabelCommonConfig.JDBC_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.PIPELINE().toString(), (String)LabelCommonConfig.PIPELINE_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.SHELL().toString(), (String)LabelCommonConfig.SHELL_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.APPCONN().toString(), (String)LabelCommonConfig.APPCONN_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.FLINK().toString(), (String)LabelCommonConfig.FLINK_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.PRESTO().toString(), (String)LabelCommonConfig.PRESTO_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.HBASE().toString(), (String)LabelCommonConfig.HBASE_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.NEBULA().toString(), (String)LabelCommonConfig.NEBULA_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.DORIS().toString(), (String)LabelCommonConfig.DORIS_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.SQOOP().toString(), (String)LabelCommonConfig.SQOOP_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.DATAX().toString(), (String)LabelCommonConfig.DATAX_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.OPENLOOKENG().toString(), (String)LabelCommonConfig.OPENLOOKENG_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.TRINO().toString(), (String)LabelCommonConfig.TRINO_ENGINE_CONN_VERSION.getValue());
            defaultVersion.put(EngineType.ELASTICSEARCH().toString(), (String)LabelCommonConfig.ELASTICSEARCH_ENGINE_VERSION.getValue());
            defaultVersion.put(EngineType.SEATUNNEL().toString(), (String)LabelCommonConfig.SEATUNNEL_ENGINE_CONN_VERSION.getValue());
            defaultVersion.put("*", "*");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static EngineTypeLabel createEngineTypeLabel(String type) {
        if (null == defaultVersion) {
            EngineTypeLabelCreator.init();
        }
        EngineTypeLabel label = labelBuilderFactory.createLabel(EngineTypeLabel.class);
        label.setEngineType(type);
        String version = defaultVersion.get(type);
        if (StringUtils.isNotBlank((CharSequence)version)) {
            label.setVersion(version);
        } else {
            label.setVersion("*");
        }
        return label;
    }

    public static void registerVersion(String type, String version) {
        if (null == defaultVersion) {
            EngineTypeLabelCreator.init();
        }
        defaultVersion.put(type, version);
    }

    static {
        EngineTypeLabelCreator.init();
    }
}

