/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.service.impl;

import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.manager.common.entity.persistence.PersistenceLabel;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.em.EMInstanceLabel;
import org.apache.linkis.manager.label.entity.engine.EngineInstanceLabel;
import org.apache.linkis.manager.label.errorcode.LabelCommonErrorCodeSummary;
import org.apache.linkis.manager.label.exception.LabelRuntimeException;
import org.apache.linkis.manager.label.service.NodeLabelRemoveService;
import org.apache.linkis.manager.label.service.NodeLabelService;
import org.apache.linkis.manager.persistence.LabelManagerPersistence;
import org.apache.linkis.protocol.label.NodeLabelRemoveRequest;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001}4Aa\u0003\u0007\u00017!)a\u0006\u0001C\u0001_!I!\u0007\u0001a\u0001\u0002\u0004%Ia\r\u0005\no\u0001\u0001\r\u00111A\u0005\naB\u0011B\u0010\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001b\t\u00131\u0003\u0001\u0019!a\u0001\n\u0013i\u0005\"\u0003+\u0001\u0001\u0004\u0005\r\u0011\"\u0003V\u0011%9\u0006\u00011A\u0001B\u0003&a\nC\u0004Z\u0001\t\u0007I\u0011\u0002.\t\r\t\u0004\u0001\u0015!\u0003\\\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0005u!UMZ1vYRtu\u000eZ3MC\n,GNU3n_Z,7+\u001a:wS\u000e,'BA\u0007\u000f\u0003\u0011IW\u000e\u001d7\u000b\u0005=\u0001\u0012aB:feZL7-\u001a\u0006\u0003#I\tQ\u0001\\1cK2T!a\u0005\u000b\u0002\u000f5\fg.Y4fe*\u0011QCF\u0001\u0007Y&t7.[:\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\u0011\u0001AD\t\u0014\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g!\t\u0019C%D\u0001\u000f\u0013\t)cB\u0001\fO_\u0012,G*\u00192fYJ+Wn\u001c<f'\u0016\u0014h/[2f!\t9C&D\u0001)\u0015\tI#&A\u0003vi&d7O\u0003\u0002,)\u000511m\\7n_:L!!\f\u0015\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\r\t\u0003c\u0001i\u0011\u0001D\u0001\u0011]>$W\rT1cK2\u001cVM\u001d<jG\u0016,\u0012\u0001\u000e\t\u0003GUJ!A\u000e\b\u0003!9{G-\u001a'bE\u0016d7+\u001a:wS\u000e,\u0017\u0001\u00068pI\u0016d\u0015MY3m'\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0002:yA\u0011QDO\u0005\u0003wy\u0011A!\u00168ji\"9QhAA\u0001\u0002\u0004!\u0014a\u0001=%c\u0005\tbn\u001c3f\u0019\u0006\u0014W\r\\*feZL7-\u001a\u0011)\u0005\u0011\u0001\u0005CA!K\u001b\u0005\u0011%BA\"E\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u000b\u001a\u000bqAZ1di>\u0014\u0018P\u0003\u0002H\u0011\u0006)!-Z1og*\u0011\u0011\nG\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&\u00111J\u0011\u0002\n\u0003V$xn^5sK\u0012\f\u0001\u0003\\1cK2\u0004VM]:jgR,gnY3\u0016\u00039\u0003\"a\u0014*\u000e\u0003AS!!\u0015\n\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003'B\u0013q\u0003T1cK2l\u0015M\\1hKJ\u0004VM]:jgR,gnY3\u0002)1\f'-\u001a7QKJ\u001c\u0018n\u001d;f]\u000e,w\fJ3r)\tId\u000bC\u0004>\r\u0005\u0005\t\u0019\u0001(\u0002#1\f'-\u001a7QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0005\u000b\u0002\b\u0001\u0006aA.\u00192fY\u001a\u000b7\r^8ssV\t1\f\u0005\u0002]A6\tQL\u0003\u0002F=*\u0011q\fE\u0001\bEVLG\u000eZ3s\u0013\t\tWLA\nMC\n,GNQ;jY\u0012,'OR1di>\u0014\u00180A\u0007mC\n,GNR1di>\u0014\u0018\u0010I\u0001\u0010e\u0016lwN^3O_\u0012,G*\u00192fYR\u0011\u0011(\u001a\u0005\u0006M*\u0001\raZ\u0001\u0017]>$W\rT1cK2\u0014V-\\8wKJ+\u0017/^3tiB\u0011\u0001\u000e\\\u0007\u0002S*\u0011\u0011C\u001b\u0006\u0003WR\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003[&\u0014aCT8eK2\u000b'-\u001a7SK6|g/\u001a*fcV,7\u000f\u001e\u0015\u0003\u0015=\u0004\"\u0001\u001d<\u000e\u0003ET!a\u0011:\u000b\u0005M$\u0018aB7fgN\fw-\u001a\u0006\u0003kR\t1A\u001d9d\u0013\t9\u0018O\u0001\u0005SK\u000e,\u0017N^3sQ\t\u0001\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}\u0011\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\u0005y\\(aB*feZL7-\u001a")
public class DefaultNodeLabelRemoveService
implements NodeLabelRemoveService,
Logging {
    @Autowired
    private NodeLabelService nodeLabelService;
    @Autowired
    private LabelManagerPersistence labelPersistence;
    private final LabelBuilderFactory labelFactory;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DefaultNodeLabelRemoveService defaultNodeLabelRemoveService = this;
        synchronized (defaultNodeLabelRemoveService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private NodeLabelService nodeLabelService() {
        return this.nodeLabelService;
    }

    private void nodeLabelService_$eq(NodeLabelService x$1) {
        this.nodeLabelService = x$1;
    }

    private LabelManagerPersistence labelPersistence() {
        return this.labelPersistence;
    }

    private void labelPersistence_$eq(LabelManagerPersistence x$1) {
        this.labelPersistence = x$1;
    }

    private LabelBuilderFactory labelFactory() {
        return this.labelFactory;
    }

    @Override
    @Receiver
    public void removeNodeLabel(NodeLabelRemoveRequest nodeLabelRemoveRequest) {
        PersistenceLabel persistenceLabel;
        this.logger().info(new StringBuilder(33).append("Start to remove labels from node ").append(nodeLabelRemoveRequest.getServiceInstance()).toString());
        if (nodeLabelRemoveRequest.getServiceInstance() == null) {
            throw new LabelRuntimeException(LabelCommonErrorCodeSummary.CHECK_LABEL_REMOVE_REQUEST.getErrorCode(), LabelCommonErrorCodeSummary.CHECK_LABEL_REMOVE_REQUEST.getErrorDesc());
        }
        this.nodeLabelService().removeLabelsFromNode(nodeLabelRemoveRequest.getServiceInstance(), nodeLabelRemoveRequest.isEngine());
        if (nodeLabelRemoveRequest.isEngine()) {
            EngineInstanceLabel engineLabel = (EngineInstanceLabel)this.labelFactory().createLabel(EngineInstanceLabel.class);
            engineLabel.setInstance(nodeLabelRemoveRequest.getServiceInstance().getInstance());
            engineLabel.setServiceName(nodeLabelRemoveRequest.getServiceInstance().getApplicationName());
            persistenceLabel = (PersistenceLabel)this.labelFactory().convertLabel((Label)engineLabel, PersistenceLabel.class);
        } else {
            EMInstanceLabel eMInstanceLabel = (EMInstanceLabel)this.labelFactory().createLabel(EMInstanceLabel.class);
            eMInstanceLabel.setServiceName(nodeLabelRemoveRequest.getServiceInstance().getApplicationName());
            eMInstanceLabel.setInstance(nodeLabelRemoveRequest.getServiceInstance().getInstance());
            persistenceLabel = (PersistenceLabel)this.labelFactory().convertLabel((Label)eMInstanceLabel, PersistenceLabel.class);
        }
        PersistenceLabel persistenceLabel2 = persistenceLabel;
        this.labelPersistence().removeLabel(persistenceLabel2);
        this.logger().info(new StringBuilder(36).append("Finished to remove labels from node ").append(nodeLabelRemoveRequest.getServiceInstance()).toString());
    }

    public DefaultNodeLabelRemoveService() {
        Logging.$init$((Logging)this);
        this.labelFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
    }
}

