/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.manager;

import feign.RetryableException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.manager.am.conf.AMConfiguration;
import org.apache.linkis.manager.am.converter.MetricsConverter;
import org.apache.linkis.manager.am.exception.AMErrorCode;
import org.apache.linkis.manager.am.exception.AMErrorException;
import org.apache.linkis.manager.am.locker.EngineNodeLocker;
import org.apache.linkis.manager.am.manager.EngineNodeManager;
import org.apache.linkis.manager.am.pointer.EngineNodePointer;
import org.apache.linkis.manager.am.pointer.NodePointerBuilder;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.metrics.NodeMetrics;
import org.apache.linkis.manager.common.entity.node.AMEngineNode;
import org.apache.linkis.manager.common.entity.node.AMNode;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.entity.node.Node;
import org.apache.linkis.manager.common.entity.node.RMNode;
import org.apache.linkis.manager.common.entity.node.ScoreServiceInstance;
import org.apache.linkis.manager.common.entity.persistence.PersistenceLabel;
import org.apache.linkis.manager.common.protocol.engine.EngineOperateRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineOperateResponse;
import org.apache.linkis.manager.common.protocol.node.NodeHeartbeatMsg;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.EngineInstanceLabel;
import org.apache.linkis.manager.persistence.LabelManagerPersistence;
import org.apache.linkis.manager.persistence.NodeManagerPersistence;
import org.apache.linkis.manager.persistence.NodeMetricManagerPersistence;
import org.apache.linkis.manager.rm.ResourceInfo;
import org.apache.linkis.manager.rm.service.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service
public class DefaultEngineNodeManager
implements EngineNodeManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEngineNodeManager.class);
    @Autowired
    private EngineNodeLocker engineLocker;
    @Autowired
    private NodeManagerPersistence nodeManagerPersistence;
    @Autowired
    private NodeMetricManagerPersistence nodeMetricManagerPersistence;
    @Autowired
    private MetricsConverter metricsConverter;
    @Autowired
    private NodePointerBuilder nodePointerBuilder;
    @Autowired
    private ResourceManager resourceManager;
    @Autowired
    private LabelManagerPersistence labelManagerPersistence;
    private final LabelBuilderFactory labelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();

    @Override
    public List<EngineNode> listEngines(String user) {
        List userNodes = this.nodeManagerPersistence.getNodes(user);
        List<EngineNode> nodes = userNodes.stream().map(Node::getServiceInstance).map(arg_0 -> ((NodeManagerPersistence)this.nodeManagerPersistence).getEngineNode(arg_0)).collect(Collectors.toList());
        List nodeMetrics = this.nodeMetricManagerPersistence.getNodeMetrics(nodes);
        Map<String, NodeMetrics> metricses = nodeMetrics.stream().collect(Collectors.toMap(m -> m.getServiceInstance().toString(), m -> m, (existingValue, newValue) -> newValue));
        nodes.forEach(node -> {
            Optional nodeMetricsOptional = Optional.ofNullable(metricses.get(node.getServiceInstance().toString()));
            nodeMetricsOptional.ifPresent(m -> this.metricsConverter.fillMetricsToNode((AMNode)node, (NodeMetrics)m));
        });
        return nodes;
    }

    @Override
    @Retryable(value={RetryableException.class, UndeclaredThrowableException.class}, maxAttempts=5, backoff=@Backoff(delay=10000L))
    public EngineNode getEngineNodeInfo(EngineNode engineNode) {
        EngineNodePointer engine = this.nodePointerBuilder.buildEngineNodePointer(engineNode);
        NodeHeartbeatMsg heartMsg = engine.getNodeHeartbeatMsg();
        engineNode.setNodeHealthyInfo(heartMsg.getHealthyInfo());
        engineNode.setNodeOverLoadInfo(heartMsg.getOverLoadInfo());
        engineNode.setNodeStatus(heartMsg.getStatus());
        return engineNode;
    }

    @Override
    public EngineNode getEngineNodeInfoByDB(EngineNode engineNode) {
        EngineNode dbEngineNode = this.nodeManagerPersistence.getEngineNode(engineNode.getServiceInstance());
        if (null == dbEngineNode) {
            throw new LinkisRetryException(30001, engineNode + " not exists in db");
        }
        this.metricsConverter.fillMetricsToNode((AMNode)dbEngineNode, this.nodeMetricManagerPersistence.getNodeMetrics((Node)dbEngineNode));
        return dbEngineNode;
    }

    @Override
    public EngineNode getEngineNodeInfoByTicketId(String ticketId) {
        EngineNode dbEngineNode = this.nodeManagerPersistence.getEngineNodeByTicketId(ticketId);
        if (null == dbEngineNode) {
            throw new LinkisRetryException(30001, ticketId + " not exists in db");
        }
        this.metricsConverter.fillMetricsToNode((AMNode)dbEngineNode, this.nodeMetricManagerPersistence.getNodeMetrics((Node)dbEngineNode));
        return dbEngineNode;
    }

    @Override
    public void updateEngineStatus(ServiceInstance serviceInstance, NodeStatus fromState, NodeStatus toState) {
    }

    @Override
    public void updateEngine(EngineNode engineNode) {
        this.nodeManagerPersistence.updateNodeInstance((Node)engineNode);
    }

    @Override
    public EngineNode switchEngine(EngineNode engineNode) {
        return null;
    }

    @Override
    public EngineNode reuseEngine(EngineNode engineNode) {
        EngineNode node = this.getEngineNodeInfo(engineNode);
        if (node == null || !NodeStatus.isAvailable((NodeStatus)node.getNodeStatus()).booleanValue()) {
            return null;
        }
        if (!NodeStatus.isLocked((NodeStatus)node.getNodeStatus()).booleanValue()) {
            Optional<String> lockStr = this.engineLocker.lockEngine(node, ((Integer)AMConfiguration.ENGINE_LOCKER_MAX_TIME.getValue()).intValue());
            if (!lockStr.isPresent()) {
                throw new LinkisRetryException(30001, String.format("Failed to request lock from engine by reuse %s", node.getServiceInstance()));
            }
            node.setLock(lockStr.get());
            return node;
        }
        return null;
    }

    @Override
    public EngineNode useEngine(EngineNode engineNode, long timeout) {
        EngineNode node = this.getEngineNodeInfo(engineNode);
        if (node == null || !NodeStatus.isAvailable((NodeStatus)node.getNodeStatus()).booleanValue()) {
            return null;
        }
        if (!NodeStatus.isLocked((NodeStatus)node.getNodeStatus()).booleanValue()) {
            Optional<String> lockStr = this.engineLocker.lockEngine(node, timeout);
            if (!lockStr.isPresent()) {
                throw new LinkisRetryException(30001, String.format("Failed to request lock from engine %s", node.getServiceInstance()));
            }
            node.setLock(lockStr.get());
            return node;
        }
        return null;
    }

    @Override
    public EngineNode useEngine(EngineNode engineNode) {
        return this.useEngine(engineNode, ((Integer)AMConfiguration.ENGINE_LOCKER_MAX_TIME.getValue()).intValue());
    }

    @Override
    public EngineNode[] getEngineNodes(ScoreServiceInstance[] scoreServiceInstances) {
        if (scoreServiceInstances == null || scoreServiceInstances.length == 0) {
            return null;
        }
        List<ScoreServiceInstance> scoreServiceInstancesList = Arrays.asList(scoreServiceInstances);
        EngineNode[] engineNodes = (EngineNode[])scoreServiceInstancesList.stream().map(scoreServiceInstance -> {
            AMEngineNode engineNode = new AMEngineNode();
            engineNode.setScore(scoreServiceInstance.getScore());
            engineNode.setServiceInstance(scoreServiceInstance.getServiceInstance());
            return engineNode;
        }).toArray(EngineNode[]::new);
        List<ServiceInstance> serviceInstancesList = scoreServiceInstancesList.stream().map(ScoreServiceInstance::getServiceInstance).collect(Collectors.toList());
        try {
            ResourceInfo resourceInfo = this.resourceManager.getResourceInfo(serviceInstancesList.toArray(new ServiceInstance[0]));
            if (serviceInstancesList.isEmpty()) {
                throw new LinkisRetryException(30001, "Service instances cannot be empty.");
            }
            List nodeMetrics = this.nodeMetricManagerPersistence.getNodeMetrics(Arrays.asList(engineNodes));
            for (EngineNode engineNode : engineNodes) {
                Optional<NodeMetrics> optionMetrics = nodeMetrics.stream().filter(nodeMetric -> nodeMetric.getServiceInstance().equals((Object)engineNode.getServiceInstance())).findFirst();
                Optional<RMNode> optionRMNode = resourceInfo.resourceInfo().stream().filter(resourceNode -> resourceNode.getServiceInstance().equals((Object)engineNode.getServiceInstance())).findFirst();
                optionMetrics.ifPresent(metrics -> this.metricsConverter.fillMetricsToNode((AMNode)engineNode, (NodeMetrics)metrics));
                optionRMNode.ifPresent(rmNode -> engineNode.setNodeResource(rmNode.getNodeResource()));
            }
        }
        catch (Exception e) {
            LinkisRetryException linkisRetryException = new LinkisRetryException(30001, "Failed to process data.");
            linkisRetryException.initCause((Throwable)e);
            throw linkisRetryException;
        }
        return engineNodes;
    }

    @Override
    public void addEngineNode(EngineNode engineNode) {
        this.nodeManagerPersistence.addEngineNode(engineNode);
        this.nodeMetricManagerPersistence.addOrupdateNodeMetrics(this.metricsConverter.getInitMetric(engineNode.getServiceInstance()));
    }

    @Override
    public void deleteEngineNode(EngineNode engineNode) {
        this.nodeManagerPersistence.deleteEngineNode(engineNode);
    }

    @Override
    public EngineNode getEngineNode(ServiceInstance serviceInstance) {
        return this.nodeManagerPersistence.getEngineNode(serviceInstance);
    }

    @Override
    public void updateEngineNode(ServiceInstance serviceInstance, EngineNode engineNode) {
        this.nodeManagerPersistence.updateEngineNode(serviceInstance, (Node)engineNode);
        this.nodeMetricManagerPersistence.deleteNodeMetrics((Node)engineNode);
        EngineInstanceLabel engineLabel = (EngineInstanceLabel)this.labelBuilderFactory.createLabel(EngineInstanceLabel.class);
        engineLabel.setInstance(engineNode.getServiceInstance().getInstance());
        engineLabel.setServiceName(engineNode.getServiceInstance().getApplicationName());
        EngineInstanceLabel oldEngineLabel = (EngineInstanceLabel)this.labelBuilderFactory.createLabel(EngineInstanceLabel.class);
        oldEngineLabel.setInstance(serviceInstance.getInstance());
        oldEngineLabel.setServiceName(engineNode.getServiceInstance().getApplicationName());
        PersistenceLabel oldPersistenceLabel = (PersistenceLabel)this.labelBuilderFactory.convertLabel((Label)oldEngineLabel, PersistenceLabel.class);
        PersistenceLabel label = this.labelManagerPersistence.getLabelByKeyValue(oldPersistenceLabel.getLabelKey(), oldPersistenceLabel.getStringValue());
        PersistenceLabel persistenceLabel = (PersistenceLabel)this.labelBuilderFactory.convertLabel((Label)engineLabel, PersistenceLabel.class);
        persistenceLabel.setLabelValueSize(((Map)persistenceLabel.getValue()).size());
        this.labelManagerPersistence.updateLabel(label.getId().intValue(), persistenceLabel);
    }

    @Override
    public EngineOperateResponse executeOperation(EngineNode engineNode, EngineOperateRequest request) {
        EngineNodePointer engine = this.nodePointerBuilder.buildEngineNodePointer(engineNode);
        return engine.executeOperation(request);
    }

    @Override
    public EngineNode getEngineNodeInfo(ServiceInstance serviceInstance) {
        EngineNode engineNode = this.getEngineNode(serviceInstance);
        if (Objects.isNull(engineNode)) {
            throw new AMErrorException(AMErrorCode.NOT_EXISTS_ENGINE_CONN.getErrorCode(), AMErrorCode.NOT_EXISTS_ENGINE_CONN.getErrorDesc());
        }
        NodeMetrics nodeMetric = this.nodeMetricManagerPersistence.getNodeMetrics((Node)engineNode);
        if (engineNode.getNodeStatus() == null) {
            if (null != nodeMetric && null != nodeMetric.getStatus()) {
                engineNode.setNodeStatus(NodeStatus.values()[nodeMetric.getStatus()]);
            } else {
                engineNode.setNodeStatus(NodeStatus.Starting);
            }
            if (null != nodeMetric && StringUtils.isNotBlank((CharSequence)nodeMetric.getHeartBeatMsg())) {
                engineNode.setEcMetrics(nodeMetric.getHeartBeatMsg());
            }
        }
        return engineNode;
    }
}

