/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.locker;

import java.util.Optional;
import org.apache.linkis.manager.am.locker.EngineNodeLocker;
import org.apache.linkis.manager.am.pointer.NodePointerBuilder;
import org.apache.linkis.manager.common.entity.node.AMEngineNode;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.protocol.RequestEngineLock;
import org.apache.linkis.manager.common.protocol.RequestEngineUnlock;
import org.apache.linkis.manager.common.protocol.RequestManagerUnlock;
import org.apache.linkis.manager.common.protocol.engine.EngineLockType;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultEngineNodeLocker
implements EngineNodeLocker {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEngineNodeLocker.class);
    @Autowired
    private NodePointerBuilder nodeBuilder;

    @Override
    public Optional<String> lockEngine(EngineNode engineNode, long timeout) {
        return this.nodeBuilder.buildEngineNodePointer(engineNode).lockEngine(new RequestEngineLock(timeout, EngineLockType.Timed));
    }

    @Override
    public void releaseLock(EngineNode engineNode, String lock) {
        this.nodeBuilder.buildEngineNodePointer(engineNode).releaseLock(new RequestEngineUnlock(lock));
    }

    @Receiver
    public void releaseLock(RequestManagerUnlock requestManagerUnlock) {
        try {
            logger.info(String.format("client%s Start to unlock engine %s", requestManagerUnlock.clientInstance(), requestManagerUnlock.engineInstance()));
            AMEngineNode engineNode = new AMEngineNode();
            engineNode.setServiceInstance(requestManagerUnlock.engineInstance());
            this.releaseLock((EngineNode)engineNode, requestManagerUnlock.lock());
            logger.info(String.format("client%s Finished to unlock engine %s", requestManagerUnlock.clientInstance(), requestManagerUnlock.engineInstance()));
        }
        catch (Exception e) {
            logger.error("release lock failed", (Throwable)e);
        }
    }
}

