/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.server.localize;

import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.common.utils.ZipUtils$;
import org.apache.linkis.engineplugin.server.localize.AbstractEngineConnBmlResourceGenerator;
import org.apache.linkis.engineplugin.server.localize.EngineConnLocalizeResource;
import org.apache.linkis.engineplugin.server.localize.EngineConnLocalizeResourceImpl;
import org.apache.linkis.manager.engineplugin.common.exception.EngineConnPluginErrorException;
import org.apache.linkis.manager.engineplugin.errorcode.EngineconnCoreErrorCodeSummary;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0002\u0004\u0001'!)\u0001\u0005\u0001C\u0001C!)1\u0005\u0001C!I!)1\u0005\u0001C!}!)!\t\u0001C\u0005\u0007\n)C)\u001a4bk2$XI\\4j]\u0016\u001cuN\u001c8C[2\u0014Vm]8ve\u000e,w)\u001a8fe\u0006$xN\u001d\u0006\u0003\u000f!\t\u0001\u0002\\8dC2L'0\u001a\u0006\u0003\u0013)\taa]3sm\u0016\u0014(BA\u0006\r\u00031)gnZ5oKBdWoZ5o\u0015\tia\"\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!\u0002\u0004\u0005\u0002\u0016-5\ta!\u0003\u0002\u0018\r\t1\u0013IY:ue\u0006\u001cG/\u00128hS:,7i\u001c8o\u00056d'+Z:pkJ\u001cWmR3oKJ\fGo\u001c:\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012!B;uS2\u001c(BA\u000f\r\u0003\u0019\u0019w.\\7p]&\u0011qD\u0007\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002\u0016\u0001\u0005Aq-\u001a8fe\u0006$X\r\u0006\u0002&yA!ae\f\u001a6\u001d\t9S\u0006\u0005\u0002)W5\t\u0011F\u0003\u0002+%\u00051AH]8pizR\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\na\u0001\u0015:fI\u00164\u0017B\u0001\u00192\u0005\ri\u0015\r\u001d\u0006\u0003]-\u0002\"AJ\u001a\n\u0005Q\n$AB*ue&tw\rE\u00027oej\u0011aK\u0005\u0003q-\u0012Q!\u0011:sCf\u0004\"!\u0006\u001e\n\u0005m2!AG#oO&tWmQ8o]2{7-\u00197ju\u0016\u0014Vm]8ve\u000e,\u0007\"B\u001f\u0003\u0001\u0004\u0011\u0014AD3oO&tWmQ8o]RK\b/\u001a\u000b\u0004k}\u0002\u0005\"B\u001f\u0004\u0001\u0004\u0011\u0004\"B!\u0004\u0001\u0004\u0011\u0014a\u0002<feNLwN\\\u0001\fO\u0016tWM]1uK\u0012K'\u000f\u0006\u00026\t\")Q\t\u0002a\u0001e\u0005!\u0001/\u0019;i\u0001")
public class DefaultEngineConnBmlResourceGenerator
extends AbstractEngineConnBmlResourceGenerator
implements Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DefaultEngineConnBmlResourceGenerator defaultEngineConnBmlResourceGenerator = this;
        synchronized (defaultEngineConnBmlResourceGenerator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Map<String, EngineConnLocalizeResource[]> generate(String engineConnType) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getEngineConnDistHomeList(engineConnType))).map((Function1 & Serializable & scala.Serializable)path -> {
            File versionFile = new File((String)path);
            this.logger().info(new StringBuilder(22).append("generate, versionFile:").append((String)path).toString());
            String key = versionFile.getName();
            if (key.contains("-")) {
                throw new EngineConnPluginErrorException(EngineconnCoreErrorCodeSummary.CONTAINS_SPECIAL_CHARCATERS.getErrorCode(), MessageFormat.format(EngineconnCoreErrorCodeSummary.CONTAINS_SPECIAL_CHARCATERS.getErrorDesc(), engineConnType));
            }
            return (Tuple2)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)this.generateDir(versionFile.getPath())), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                Throwable throwable = x0$1;
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    this.logger().error(new StringBuilder(29).append("Generate dir : ").append((String)path).append(" error, msg : ").append(throwable2.getMessage()).toString(), throwable2);
                    throw throwable2;
                }
                throw new MatchError((Object)throwable);
            });
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public EngineConnLocalizeResource[] generate(String engineConnType, String version) {
        String path = this.getEngineConnDistHome(engineConnType, version);
        return this.generateDir(path);
    }

    private EngineConnLocalizeResource[] generateDir(String path) {
        File distFile = new File(path);
        this.logger().info(new StringBuilder(22).append("generateDir, distFile:").append(path).toString());
        File[] validFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])distFile.listFiles())).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DefaultEngineConnBmlResourceGenerator.$anonfun$generateDir$1(path, f)));
        return (EngineConnLocalizeResource[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])validFiles)).map((Function1 & Serializable & scala.Serializable)file -> {
            if (file.isFile()) {
                return new EngineConnLocalizeResourceImpl(file.getPath(), file.getName(), file.lastModified(), file.length());
            }
            File newFile = new File(path, new StringBuilder(4).append(file.getName()).append(".zip").toString());
            if (newFile.exists() && !newFile.delete()) {
                throw new EngineConnPluginErrorException(EngineconnCoreErrorCodeSummary.NO_PERMISSION_FILE.getErrorCode(), MessageFormat.format(EngineconnCoreErrorCodeSummary.NO_PERMISSION_FILE.getErrorDesc(), newFile));
            }
            ZipUtils$.MODULE$.fileToZip(file.getPath(), path, new StringBuilder(4).append(file.getName()).append(".zip").toString());
            return new EngineConnLocalizeResourceImpl(newFile.getPath(), newFile.getName(), file.lastModified(), newFile.length());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(EngineConnLocalizeResource.class)));
    }

    public static final /* synthetic */ boolean $anonfun$generateDir$1(String path$2, File f) {
        return f.getName().endsWith(".zip") && new File(path$2, f.getName().replace(".zip", "")).exists();
    }

    public DefaultEngineConnBmlResourceGenerator() {
        Logging.$init$((Logging)this);
    }
}

