/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.loader.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineConnPluginClassLoader
extends URLClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(EngineConnPluginClassLoader.class);
    private boolean reverseOrder = false;
    private List<ClassLoader> extendedLoaders = new ArrayList<ClassLoader>();

    public EngineConnPluginClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public EngineConnPluginClassLoader(URL[] urls, ClassLoader parent, List<ClassLoader> extendedLoaders, boolean reverseOrder) {
        super(urls, parent);
        this.extendedLoaders = extendedLoaders;
        this.reverseOrder = reverseOrder;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (!this.extendedLoaders.isEmpty()) {
            for (ClassLoader extend : this.extendedLoaders) {
                try {
                    return extend.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return super.findClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClassReverse(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (c == null) {
                    return super.loadClass(name, resolve);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.reverseOrder) {
            return this.loadClassReverse(name, resolve);
        }
        return super.loadClass(name, resolve);
    }

    public static EngineConnPluginClassLoader custom(URL[] urls, ClassLoader parent) {
        return EngineConnPluginClassLoader.custom(urls, parent, Collections.emptyList(), false);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public static EngineConnPluginClassLoader custom(URL[] urls, ClassLoader parent, List<ClassLoader> extendedLoaders) {
        return EngineConnPluginClassLoader.custom(urls, parent, extendedLoaders, false);
    }

    public static EngineConnPluginClassLoader custom(URL[] urls, ClassLoader parent, List<ClassLoader> extendedLoaders, boolean reverseOrder) {
        return AccessController.doPrivileged(() -> new EngineConnPluginClassLoader(urls, parent, Collections.emptyList(), reverseOrder));
    }
}

