/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.engineconn.common.conf.EngineConnConf$;
import org.apache.linkis.engineconn.common.conf.EngineConnConstant$;
import org.apache.linkis.engineplugin.spark.utils.DataFrameResponse;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.runtime.BoxesRunTime;

public final class DirectPushCache$ {
    public static DirectPushCache$ MODULE$;
    private final Cache<String, Dataset<Row>> resultSet;

    static {
        new DirectPushCache$();
    }

    private Cache<String, Dataset<Row>> resultSet() {
        return this.resultSet;
    }

    public DataFrameResponse fetchResultSetOfDataFrame(String taskId, int fetchSize) {
        Dataset df = (Dataset)this.resultSet().getIfPresent((Object)taskId);
        if (df == null) {
            throw new IllegalAccessException(new StringBuilder(36).append("Task ").append(taskId).append(" not exists in resultSet cache.").toString());
        }
        Dataset batchDf = df.limit(fetchSize);
        if (batchDf.count() < (long)fetchSize) {
            this.resultSet().invalidate((Object)taskId);
            return new DataFrameResponse((Dataset<Row>)batchDf, false);
        }
        this.resultSet().put((Object)taskId, (Object)df.except(batchDf));
        return new DataFrameResponse((Dataset<Row>)batchDf, true);
    }

    public boolean isTaskCached(String taskId) {
        return this.resultSet().getIfPresent((Object)taskId) != null;
    }

    public void submitExecuteResult(String taskId, Dataset<Row> df) {
        this.resultSet().put((Object)taskId, df);
    }

    private DirectPushCache$() {
        MODULE$ = this;
        this.resultSet = CacheBuilder.newBuilder().expireAfterAccess((long)BoxesRunTime.unboxToInt((Object)EngineConnConf$.MODULE$.ENGINE_TASK_EXPIRE_TIME().getValue()), TimeUnit.MILLISECONDS).maximumSize((long)EngineConnConstant$.MODULE$.MAX_TASK_NUM()).build();
    }
}

