/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.source;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.linkis.engineplugin.spark.datacalc.model.SourceConfig;

public class FileSourceConfig
extends SourceConfig {
    @NotBlank
    @Pattern(regexp="^(((file|hdfs)://)|/).*", message="Invalid path URI, please set the following allowed schemas: 'file://' or 'hdfs://'(default).")
    private @NotBlank @Pattern(regexp="^(((file|hdfs)://)|/).*", message="Invalid path URI, please set the following allowed schemas: 'file://' or 'hdfs://'(default).") String path;
    @NotBlank
    private String serializer = "parquet";
    private String[] columnNames;

    public String getPath() {
        if (this.path.startsWith("/")) {
            return "hdfs://" + this.path;
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSerializer() {
        return this.serializer;
    }

    public void setSerializer(String serializer) {
        this.serializer = serializer;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }
}

