/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.protocol.utils;

import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.ServiceInstance$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class ZuulEntranceUtils$ {
    public static ZuulEntranceUtils$ MODULE$;
    private final String INSTANCE_SPLIT_TOKEN;
    private final String EXEC_ID;
    private final int SPLIT_LEN;

    static {
        new ZuulEntranceUtils$();
    }

    private String INSTANCE_SPLIT_TOKEN() {
        return this.INSTANCE_SPLIT_TOKEN;
    }

    public String EXEC_ID() {
        return this.EXEC_ID;
    }

    private int SPLIT_LEN() {
        return this.SPLIT_LEN;
    }

    public String[] parseExecID(String longExecID) {
        if (longExecID.startsWith(this.EXEC_ID())) {
            String content = longExecID.replaceFirst(this.EXEC_ID(), "");
            int applicationNameLength = Integer.parseInt(content.substring(0, this.SPLIT_LEN()));
            int instanceLength = Integer.parseInt(content.substring(this.SPLIT_LEN(), this.SPLIT_LEN() * 2));
            String applicationName = content.substring(this.SPLIT_LEN() * 2, this.SPLIT_LEN() * 2 + applicationNameLength);
            String instances = content.substring(this.SPLIT_LEN() * 2 + applicationNameLength, this.SPLIT_LEN() * 2 + applicationNameLength + instanceLength);
            String shortExecID = content.substring(this.SPLIT_LEN() * 2 + applicationNameLength + instanceLength, content.length());
            return (String[])((Object[])new String[]{this.EXEC_ID(), applicationName, instances, shortExecID});
        }
        int creatorLength = Integer.parseInt(longExecID.substring(0, 2));
        int executeLength = Integer.parseInt(longExecID.substring(2, 4));
        int instanceLength = Integer.parseInt(longExecID.substring(4, 6));
        String creator = longExecID.substring(6, 6 + creatorLength);
        String executeApplicationName = longExecID.substring(6 + creatorLength, 6 + creatorLength + executeLength);
        String instance = longExecID.substring(6 + creatorLength + executeLength, 6 + creatorLength + executeLength + instanceLength);
        String shortExecID = longExecID.substring(6 + creatorLength + executeLength + instanceLength, longExecID.length());
        return (String[])((Object[])new String[]{creator, executeApplicationName, instance, shortExecID});
    }

    public String generateExecID(String shortExecID, String executeApplicationName, String instance, String creator) {
        String creatorLength = this.getLengthStr(creator);
        String executeLength = this.getLengthStr(executeApplicationName);
        String instanceLength = this.getLengthStr(instance);
        return new StringBuilder(0).append(creatorLength).append(executeLength).append(instanceLength).append(creator).append(executeApplicationName).append(instance).append(shortExecID).toString();
    }

    private boolean isNumberic(String s) {
        boolean bl;
        Object object = new Object();
        try {
            new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(s.toCharArray())).foreach((Function1 & java.io.Serializable & Serializable)c -> {
                ZuulEntranceUtils$.$anonfun$isNumberic$1(object, BoxesRunTime.unboxToChar((Object)c));
                return BoxedUnit.UNIT;
            });
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public String generateExecID(String shortExecID, String executeApplicationName, String instance) {
        String executeLength = this.getLengthStr(executeApplicationName);
        String instanceLength = this.getLengthStr(instance);
        if (shortExecID.split("_").length == 3) {
            String creator = shortExecID.split("_")[0];
            String creatorLength = this.getLengthStr(creator);
            return new StringBuilder(0).append(creatorLength).append(executeLength).append(instanceLength).append(creator).append(executeApplicationName).append(instance).append(shortExecID).toString();
        }
        return new StringBuilder(0).append(executeLength).append(instanceLength).append(executeApplicationName).append(instance).append(shortExecID).toString();
    }

    public ServiceInstance[] parseServiceInstanceByExecID(String longExecID) {
        if (longExecID.startsWith(this.EXEC_ID())) {
            String content = longExecID.replaceFirst(this.EXEC_ID(), "");
            int applicationNameLength = Integer.parseInt(content.substring(0, this.SPLIT_LEN()));
            int instanceLength = Integer.parseInt(content.substring(this.SPLIT_LEN(), this.SPLIT_LEN() * 2));
            String applicationName = content.substring(this.SPLIT_LEN() * 2, this.SPLIT_LEN() * 2 + applicationNameLength);
            String instances = content.substring(this.SPLIT_LEN() * 2 + applicationNameLength, this.SPLIT_LEN() * 2 + applicationNameLength + instanceLength);
            String shortExecID = content.substring(this.SPLIT_LEN() * 2 + applicationNameLength + instanceLength, content.length());
            return (ServiceInstance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instances.split(this.INSTANCE_SPLIT_TOKEN()))).map((Function1 & java.io.Serializable & Serializable)x$1 -> ServiceInstance$.MODULE$.apply(applicationName, x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ServiceInstance.class)));
        }
        int creatorLength = Integer.parseInt(longExecID.substring(0, 2));
        int executeLength = Integer.parseInt(longExecID.substring(2, 4));
        int instanceLength = Integer.parseInt(longExecID.substring(4, 6));
        String executeApplicationName = longExecID.substring(6 + creatorLength, 6 + creatorLength + executeLength);
        String instance = longExecID.substring(6 + creatorLength + executeLength, 6 + creatorLength + executeLength + instanceLength);
        return (ServiceInstance[])((Object[])new ServiceInstance[]{ServiceInstance$.MODULE$.apply(executeApplicationName, instance)});
    }

    private String getLengthStr(String string) {
        int length = string.length();
        if (length >= 10) {
            return String.valueOf(length);
        }
        return new StringBuilder(1).append("0").append(String.valueOf(length)).toString();
    }

    public String generateExecID(String shortExecID, String applicationName, String[] instances) {
        if (instances == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instances)).isEmpty()) {
            throw new RuntimeException("failed to generate ExecID ,the parameters instance is not null (\u751f\u6210ExecID\u5931\u8d25\uff0c\u4f20\u5165\u7684Instance\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        String applicationNameLength = this.getStrFixedLen(applicationName, this.SPLIT_LEN());
        String instanceStr = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instances)).mkString(this.INSTANCE_SPLIT_TOKEN());
        String instanceStrLength = this.getStrFixedLen(instanceStr, this.SPLIT_LEN());
        return new StringBuilder(0).append(this.EXEC_ID()).append(applicationNameLength).append(instanceStrLength).append(applicationName).append(instanceStr).append(shortExecID).toString();
    }

    private String getStrFixedLen(String string, int len) {
        String str = String.valueOf(string.length());
        String res = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("0")).$times(len - str.length())).append(str).toString();
        return res;
    }

    public static final /* synthetic */ void $anonfun$isNumberic$1(Object nonLocalReturnKey1$1, char c) {
        if (c < '0' || c > '9') {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }

    private ZuulEntranceUtils$() {
        MODULE$ = this;
        this.INSTANCE_SPLIT_TOKEN = "_";
        this.EXEC_ID = "exec_id";
        this.SPLIT_LEN = 3;
    }
}

